/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DocCommentBlock
extends AbstractJavaBlock {
    public DocCommentBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CodeStyleSettings settings) {
        super(node, wrap, alignment, indent, settings);
    }

    @Override
    protected List<Block> buildChildren() {
        ArrayList<Block> result = new ArrayList<Block>();
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == ElementType.DOC_COMMENT_START) {
                result.add(DocCommentBlock.createJavaBlock(child, this.mySettings, Indent.getNoneIndent(), null, null));
                continue;
            }
            if (FormatterUtil.containsWhiteSpacesOnly(child) || child.getText().trim().length() <= 0) continue;
            result.add(DocCommentBlock.createJavaBlock(child, this.mySettings, Indent.getSpaceIndent((int)1), null, null));
        }
        return result;
    }

    @Override
    protected Wrap getReservedWrap(IElementType elementType) {
        return null;
    }

    @Override
    protected void setReservedWrap(Wrap reservedWrap, IElementType operationType) {
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = new ChildAttributes(Indent.getSpaceIndent((int)1), null);
        if (childAttributes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/DocCommentBlock.getChildAttributes must not return null");
        }
        return childAttributes;
    }
}

