/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import org.jetbrains.annotations.NotNull;

public class FormattingDocumentModelImpl
implements FormattingDocumentModel {
    private final Document myDocument;
    private final PsiFile myFile;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.FormattingDocumentModelImpl");

    public FormattingDocumentModelImpl(Document document, PsiFile file) {
        this.myDocument = document;
        this.myFile = file;
    }

    public static FormattingDocumentModelImpl createOn(PsiFile file) {
        Document document = FormattingDocumentModelImpl.getDocumentToBeUsedFor(file);
        if (document != null) {
            if (PsiDocumentManager.getInstance((Project)file.getProject()).isUncommited(document)) {
                LOG.error("Document is uncommited");
            }
            if (!document.getText().equals(file.getText())) {
                LOG.error("Document and psi file texts should be equal : \nDocument text:\n" + document.getText() + "\nFile text:\n" + file.getText());
            }
            return new FormattingDocumentModelImpl(document, file);
        }
        return new FormattingDocumentModelImpl(new DocumentImpl(file.getText()), file);
    }

    public static Document getDocumentToBeUsedFor(PsiFile file) {
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return null;
        }
        if (PsiDocumentManager.getInstance((Project)project).isUncommited(document)) {
            return null;
        }
        PsiToDocumentSynchronizer synchronizer = ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)file.getProject())).getSynchronizer();
        if (synchronizer.isDocumentAffectedByTransactions(document)) {
            return null;
        }
        return document;
    }

    public int getLineNumber(int offset) {
        LOG.assertTrue(offset <= this.myDocument.getTextLength());
        return this.myDocument.getLineNumber(offset);
    }

    public int getLineStartOffset(int line) {
        return this.myDocument.getLineStartOffset(line);
    }

    public CharSequence getText(TextRange textRange) {
        return this.myDocument.getCharsSequence().subSequence(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public int getTextLength() {
        return this.myDocument.getTextLength();
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public static boolean canUseDocumentModel(@NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/formatter/FormattingDocumentModelImpl.canUseDocumentModel must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/formatter/FormattingDocumentModelImpl.canUseDocumentModel must not be null");
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        return !psiDocumentManager.isUncommited(document) && !psiDocumentManager.isDocumentBlockedByPsi(document) && file.getText().equals(document.getText());
    }
}

