/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentBasedFormattingModel
implements FormattingModel {
    private final Block myRootBlock;
    private final FormattingDocumentModel myDocumentModel;
    private final Document myDocument;
    private final Project myProject;
    private final CodeStyleSettings mySettings;
    private final FileType myFileType;

    public DocumentBasedFormattingModel(Block rootBlock, Document document, Project project, CodeStyleSettings settings, FileType fileType, PsiFile file) {
        this.myRootBlock = rootBlock;
        this.myDocument = document;
        this.myProject = project;
        this.mySettings = settings;
        this.myFileType = fileType;
        this.myDocumentModel = new FormattingDocumentModelImpl(document, file);
    }

    public DocumentBasedFormattingModel(Block rootBlock, Project project, CodeStyleSettings settings, FileType fileType, PsiFile file) {
        this.myRootBlock = rootBlock;
        this.myProject = project;
        this.mySettings = settings;
        this.myFileType = fileType;
        this.myDocumentModel = FormattingDocumentModelImpl.createOn(file);
        this.myDocument = this.myDocumentModel.getDocument();
    }

    @NotNull
    public Block getRootBlock() {
        Block block = this.myRootBlock;
        if (block == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/DocumentBasedFormattingModel.getRootBlock must not return null");
        }
        return block;
    }

    @NotNull
    public FormattingDocumentModel getDocumentModel() {
        FormattingDocumentModel formattingDocumentModel = this.myDocumentModel;
        if (formattingDocumentModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/DocumentBasedFormattingModel.getDocumentModel must not return null");
        }
        return formattingDocumentModel;
    }

    /*
     * Unable to fully structure code
     */
    public TextRange replaceWhiteSpace(TextRange textRange, String whiteSpace) {
        block9: {
            block8: {
                marker = "<![CDATA[";
                if (this.removesPattern(textRange, whiteSpace, "<![CDATA[")) ** GOTO lbl-1000
                marker = "<!--[";
                if (this.removesPattern(textRange, whiteSpace, "<!--[")) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = removesStartMarker = false;
                }
                if (v0) break block8;
                marker = "]]>";
                if (this.removesPattern(textRange, whiteSpace, "]]>")) break block8;
                marker = "]-->";
                if (!this.removesPattern(textRange, whiteSpace, "]-->")) break block9;
            }
            newWs = null;
            if (removesStartMarker) {
                at = CharArrayUtil.indexOf((CharSequence)this.myDocument.getCharsSequence(), (CharSequence)marker, (int)textRange.getStartOffset(), (int)(textRange.getEndOffset() + 1));
                ws = this.myDocument.getCharsSequence().subSequence(textRange.getStartOffset(), textRange.getEndOffset()).toString();
                newWs = DocumentBasedFormattingModel.mergeWsWithCdataMarker(whiteSpace, ws, at - textRange.getStartOffset());
                v1 = newWs != null ? newWs : whiteSpace;
                marker = "]]>";
                if (this.removesPattern(textRange, v1, "]]>") && newWs != null && (i = newWs.lastIndexOf(10)) > 0) {
                    cdataStart = newWs.indexOf("<![CDATA[");
                    i2 = newWs.lastIndexOf(10, cdataStart);
                    cdataIndent = i2 != -1 ? newWs.substring(i2 + 1, cdataStart) : "";
                    newWs = newWs.substring(0, i) + cdataIndent + marker + newWs.substring(i);
                }
            }
            if (newWs == null) {
                return textRange;
            }
            whiteSpace = newWs;
        }
        this.myDocument.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)whiteSpace);
        return new TextRange(textRange.getStartOffset(), textRange.getStartOffset() + whiteSpace.length());
    }

    private boolean removesPattern(TextRange textRange, String whiteSpace, String pattern) {
        return CharArrayUtil.indexOf((CharSequence)this.myDocument.getCharsSequence(), (CharSequence)pattern, (int)textRange.getStartOffset(), (int)(textRange.getEndOffset() + 1)) != -1 && CharArrayUtil.indexOf((CharSequence)whiteSpace, (CharSequence)pattern, (int)0) == -1;
    }

    public TextRange shiftIndentInsideRange(TextRange range, int indent) {
        int newLength = this.shiftIndentInside(range, indent);
        return new TextRange(range.getStartOffset(), range.getStartOffset() + newLength);
    }

    public void commitChanges() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
    }

    private int shiftIndentInside(TextRange elementRange, int shift) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer afterWhiteSpace = new StringBuffer();
        int whiteSpaceLength = 0;
        boolean insideWhiteSpace = true;
        int line = 0;
        block5: for (int i = elementRange.getStartOffset(); i < elementRange.getEndOffset(); ++i) {
            char c = this.myDocument.getCharsSequence().charAt(i);
            switch (c) {
                case '\n': {
                    if (line > 0) {
                        this.createWhiteSpace(whiteSpaceLength + shift, buffer);
                    }
                    buffer.append(afterWhiteSpace.toString());
                    insideWhiteSpace = true;
                    whiteSpaceLength = 0;
                    afterWhiteSpace = new StringBuffer();
                    buffer.append(c);
                    ++line;
                    continue block5;
                }
                case ' ': {
                    if (insideWhiteSpace) {
                        ++whiteSpaceLength;
                        continue block5;
                    }
                    afterWhiteSpace.append(c);
                    continue block5;
                }
                case '\t': {
                    if (insideWhiteSpace) {
                        whiteSpaceLength += this.getIndentOptions().TAB_SIZE;
                        continue block5;
                    }
                    afterWhiteSpace.append(c);
                    continue block5;
                }
                default: {
                    insideWhiteSpace = false;
                    afterWhiteSpace.append(c);
                }
            }
        }
        if (line > 0) {
            this.createWhiteSpace(whiteSpaceLength + shift, buffer);
        }
        buffer.append(afterWhiteSpace.toString());
        this.myDocument.replaceString(elementRange.getStartOffset(), elementRange.getEndOffset(), (CharSequence)buffer.toString());
        return buffer.length();
    }

    private void createWhiteSpace(int whiteSpaceLength, StringBuffer buffer) {
        if (whiteSpaceLength < 0) {
            return;
        }
        CodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions();
        if (indentOptions.USE_TAB_CHARACTER) {
            int tabs = whiteSpaceLength / indentOptions.TAB_SIZE;
            int spaces = whiteSpaceLength - tabs * indentOptions.TAB_SIZE;
            StringUtil.repeatSymbol((Appendable)buffer, (char)'\t', (int)tabs);
            StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)spaces);
        } else {
            StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)whiteSpaceLength);
        }
    }

    private CodeStyleSettings.IndentOptions getIndentOptions() {
        return this.mySettings.getIndentOptions(this.myFileType);
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public static String mergeWsWithCdataMarker(String whiteSpace, String s, int cdataPos) {
        int firstCrInGeneratedWs = whiteSpace.indexOf(10);
        int secondCrInGeneratedWs = firstCrInGeneratedWs != -1 ? whiteSpace.indexOf(10, firstCrInGeneratedWs + 1) : -1;
        int firstCrInPreviousWs = s.indexOf(10);
        int secondCrInPreviousWs = firstCrInPreviousWs != -1 ? s.indexOf(10, firstCrInPreviousWs + 1) : -1;
        boolean knowHowToModifyCData = false;
        if (secondCrInPreviousWs != -1 && secondCrInGeneratedWs != -1 && cdataPos > firstCrInPreviousWs && cdataPos < secondCrInPreviousWs) {
            whiteSpace = whiteSpace.substring(0, secondCrInGeneratedWs) + s.substring(firstCrInPreviousWs + 1, secondCrInPreviousWs) + whiteSpace.substring(secondCrInGeneratedWs);
            knowHowToModifyCData = true;
        }
        if (!knowHowToModifyCData) {
            whiteSpace = null;
        }
        return whiteSpace;
    }
}

