/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.psi.filters.getters.ClassLiteralLookupElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ClassLiteralGetter {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.filters.getters.ClassLiteralGetter");

    private ClassLiteralGetter() {
    }

    public static LookupElement[] getClassLiterals(PsiElement context, CompletionContext completionContext, final PrefixMatcher matcher, ContextGetter myBaseGetter) {
        Condition<String> shortNameCondition = new Condition<String>(){

            public boolean value(String s) {
                return matcher.prefixMatches(s);
            }
        };
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        for (Object element : myBaseGetter.get(context, completionContext)) {
            PsiClass aClass;
            PsiTypeParameter[] typeParameters;
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass psiClass;
            if (!(element instanceof PsiClassType) || (psiClass = (resolveResult = ((PsiClassType)element).resolveGenerics()).getElement()) == null || !"java.lang.Class".equals(psiClass.getQualifiedName()) || (typeParameters = psiClass.getTypeParameters()).length != 1) continue;
            PsiType substitution = resolveResult.getSubstitutor().substitute(typeParameters[0]);
            boolean addInheritors = false;
            if (substitution instanceof PsiWildcardType) {
                PsiWildcardType wildcardType = (PsiWildcardType)substitution;
                substitution = wildcardType.getBound();
                addInheritors = wildcardType.isExtends();
            }
            if ((aClass = PsiUtil.resolveClassInType((PsiType)substitution)) == null) continue;
            ClassLiteralGetter.createLookupElement(substitution, result, context);
            if (!addInheritors || substitution == null || "java.lang.Object".equals(substitution.getCanonicalText())) continue;
            for (PsiType type : CodeInsightUtil.addSubtypes(substitution, context, true, shortNameCondition)) {
                ClassLiteralGetter.createLookupElement(type, result, context);
            }
        }
        return result.toArray(new LookupElement[result.size()]);
    }

    private static void createLookupElement(@Nullable PsiType type, List<LookupElement> list, PsiElement context) {
        if (type instanceof PsiClassType && !((PsiClassType)type).hasParameters() && !(((PsiClassType)type).resolve() instanceof PsiTypeParameter)) {
            try {
                list.add(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy((LookupElement)new ClassLiteralLookupElement((PsiClassType)type, context)));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

