/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.core.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PomModelImpl
extends UserDataHolderBase
implements PomModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.pom.core.impl.PomModelImpl");
    private final Project myProject;
    private final Map<Class<? extends PomModelAspect>, PomModelAspect> myAspects = new HashMap<Class<? extends PomModelAspect>, PomModelAspect>();
    private final Map<PomModelAspect, List<PomModelAspect>> myIncidence = new HashMap<PomModelAspect, List<PomModelAspect>>();
    private final Map<PomModelAspect, List<PomModelAspect>> myInvertedIncidence = new HashMap<PomModelAspect, List<PomModelAspect>>();
    private final Collection<PomModelListener> myListeners = new ArrayList<PomModelListener>();
    private final Stack<Pair<PomModelAspect, PomTransaction>> myBlockedAspects = new Stack();
    private PomModelListener[] myListenersArray = null;

    public PomModelImpl(Project project) {
        this.myProject = project;
    }

    public <T extends PomModelAspect> T getModelAspect(Class<T> aClass) {
        return (T)this.myAspects.get(aClass);
    }

    public void registerAspect(Class<? extends PomModelAspect> aClass, PomModelAspect aspect, Set<PomModelAspect> dependencies) {
        this.myAspects.put(aClass, aspect);
        Iterator<PomModelAspect> iterator = dependencies.iterator();
        ArrayList<PomModelAspect> deps = new ArrayList<PomModelAspect>();
        while (iterator.hasNext()) {
            PomModelAspect depend = iterator.next();
            deps.addAll(this.getAllDependencies(depend));
        }
        deps.add(aspect);
        for (PomModelAspect pomModelAspect : deps) {
            List<PomModelAspect> pomModelAspects = this.myInvertedIncidence.get(pomModelAspect);
            if (pomModelAspects != null) {
                pomModelAspects.add(aspect);
                continue;
            }
            this.myInvertedIncidence.put(pomModelAspect, new ArrayList<PomModelAspect>(Collections.singletonList(aspect)));
        }
        this.myIncidence.put(aspect, deps);
    }

    private List<PomModelAspect> getAllDependencies(PomModelAspect aspect) {
        List<PomModelAspect> pomModelAspects = this.myIncidence.get(aspect);
        return pomModelAspects != null ? pomModelAspects : Collections.emptyList();
    }

    private List<PomModelAspect> getAllDependants(PomModelAspect aspect) {
        List<PomModelAspect> pomModelAspects = this.myInvertedIncidence.get(aspect);
        return pomModelAspects != null ? pomModelAspects : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(PomModelListener listener) {
        Collection<PomModelListener> collection = this.myListeners;
        synchronized (collection) {
            this.myListeners.add(listener);
            this.myListenersArray = null;
        }
    }

    public void addModelListener(final PomModelListener listener, Disposable parentDisposable) {
        this.addModelListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                PomModelImpl.this.removeModelListener(listener);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(PomModelListener listener) {
        Collection<PomModelListener> collection = this.myListeners;
        synchronized (collection) {
            this.myListeners.remove(listener);
            this.myListenersArray = null;
        }
    }

    /*
     * Exception decompiling
     */
    public void runTransaction(PomTransaction transaction) throws IncorrectOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK], 15[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private Pair<PomModelAspect, PomTransaction> getBlockingTransaction(PomModelAspect aspect, PomTransaction transaction) {
        List<PomModelAspect> allDependants = this.getAllDependants(aspect);
        for (PomModelAspect pomModelAspect : allDependants) {
            ListIterator blocksIterator = this.myBlockedAspects.listIterator(this.myBlockedAspects.size());
            while (blocksIterator.hasPrevious()) {
                Pair pair = (Pair)blocksIterator.previous();
                if (pomModelAspect != pair.getFirst() || !PsiTreeUtil.isAncestor((PsiElement)((PomTransaction)pair.getSecond()).getChangeScope(), (PsiElement)transaction.getChangeScope(), (boolean)false) || PomModelImpl.getContainingFileByTree(((PomTransaction)pair.getSecond()).getChangeScope()) == null) continue;
                return pair;
            }
        }
        return null;
    }

    private void commitTransaction(PomTransaction transaction) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        PsiDocumentManagerImpl manager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)this.myProject);
        PsiToDocumentSynchronizer synchronizer = manager.getSynchronizer();
        Document document = null;
        PsiFile containingFileByTree = PomModelImpl.getContainingFileByTree(transaction.getChangeScope());
        if (containingFileByTree != null) {
            document = manager.getCachedDocument(containingFileByTree);
        }
        if (document != null) {
            synchronizer.commitTransaction(document);
        }
        if (progressIndicator != null) {
            progressIndicator.finishNonCancelableSection();
        }
    }

    private void startTransaction(PomTransaction transaction) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.startNonCancelableSection();
        }
        PsiDocumentManagerImpl manager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)this.myProject);
        PsiToDocumentSynchronizer synchronizer = manager.getSynchronizer();
        PsiElement changeScope = transaction.getChangeScope();
        PomModelImpl.sendPsiBeforeEvent(transaction.getChangeScope());
        LOG.assertTrue(changeScope != null);
        PsiFile containingFileByTree = PomModelImpl.getContainingFileByTree(changeScope);
        Document document = null;
        if (containingFileByTree != null) {
            document = manager.getCachedDocument(containingFileByTree);
        }
        if (document != null) {
            synchronizer.startTransaction(document, transaction.getChangeScope());
        }
    }

    @Nullable
    private static PsiFile getContainingFileByTree(@NotNull PsiElement changeScope) {
        PsiFile psiFile;
        if (changeScope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/core/impl/PomModelImpl.getContainingFileByTree must not be null");
        }
        ASTNode node = changeScope.getNode();
        if (node == null) {
            psiFile = changeScope.getContainingFile();
        } else {
            FileElement fileElement = TreeUtil.getFileElement((TreeElement)node);
            if (fileElement == null) {
                return null;
            }
            psiFile = (PsiFile)fileElement.getPsi();
        }
        return psiFile.getNode() != null ? psiFile : null;
    }

    private static void sendPsiBeforeEvent(PsiElement scope) {
        if (!scope.isPhysical()) {
            return;
        }
        PsiManagerImpl manager = (PsiManagerImpl)scope.getManager();
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(manager);
        event.setParent(scope);
        event.setFile(scope.getContainingFile());
        event.setOffset(scope.getTextRange().getStartOffset());
        event.setOldLength(scope.getTextLength());
        manager.beforeChildrenChange(event);
    }

    private PomModelListener[] getListeners() {
        if (this.myListenersArray != null) {
            return this.myListenersArray;
        }
        this.myListenersArray = this.myListeners.toArray(new PomModelListener[this.myListeners.size()]);
        return this.myListenersArray;
    }
}

