/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.compiler.make.ManifestBuilder;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestFileUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorContextImpl");
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    public static final String MANIFEST_FILE_NAME = PathUtil.getFileName((String)"META-INF/MANIFEST.MF");
    public static final String MANIFEST_DIR_NAME = PathUtil.getParentPath((String)"META-INF/MANIFEST.MF");

    private ManifestFileUtil() {
    }

    @Nullable
    public static VirtualFile findManifestFile(@NotNull CompositePackagingElement<?> root, PackagingElementResolvingContext context, ArtifactType artifactType) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ManifestFileUtil.findManifestFile must not be null");
        }
        return ArtifactUtil.findSourceFileByOutputPath(root, MANIFEST_PATH, context, artifactType);
    }

    @Nullable
    public static VirtualFile suggestManifestFileDirectory(@NotNull CompositePackagingElement<?> root, PackagingElementResolvingContext context, ArtifactType artifactType) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ManifestFileUtil.suggestManifestFileDirectory must not be null");
        }
        VirtualFile metaInfDir = ArtifactUtil.findSourceFileByOutputPath(root, MANIFEST_DIR_NAME, context, artifactType);
        if (metaInfDir != null) {
            return metaInfDir;
        }
        final Ref sourceDir = Ref.create(null);
        final Ref sourceFile = Ref.create(null);
        ArtifactUtil.processElementsWithSubstitutions(root.getChildren(), context, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                VirtualFile file;
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ManifestFileUtil$1.process must not be null");
                }
                if (path == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/ManifestFileUtil$1.process must not be null");
                }
                if (element instanceof FileCopyPackagingElement) {
                    VirtualFile file2 = ((FileCopyPackagingElement)element).findFile();
                    if (file2 != null) {
                        sourceFile.set((Object)file2);
                    }
                } else if (element instanceof DirectoryCopyPackagingElement && (file = ((DirectoryCopyPackagingElement)element).findFile()) != null) {
                    sourceDir.set((Object)file);
                    return false;
                }
                return true;
            }
        });
        if (!sourceDir.isNull()) {
            return (VirtualFile)sourceDir.get();
        }
        Project project = context.getProject();
        return ManifestFileUtil.suggestBaseDir(project, (VirtualFile)sourceFile.get());
    }

    @Nullable
    private static VirtualFile suggestBaseDir(Project project, @Nullable VirtualFile file) {
        VirtualFile[] contentRoots = ProjectRootManager.getInstance((Project)project).getContentRoots();
        if (file == null && contentRoots.length > 0) {
            return contentRoots[0];
        }
        if (file != null) {
            for (VirtualFile contentRoot : contentRoots) {
                if (!VfsUtil.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) continue;
                return contentRoot;
            }
        }
        return project.getBaseDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest readManifest(@NotNull VirtualFile manifestFile) {
        if (manifestFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ManifestFileUtil.readManifest must not be null");
        }
        try {
            Manifest manifest;
            InputStream inputStream = manifestFile.getInputStream();
            try {
                manifest = new Manifest(inputStream);
            }
            finally {
                inputStream.close();
            }
            return manifest;
        }
        catch (IOException ignored) {
            return new Manifest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateManifest(VirtualFile file, String mainClass, List<String> classpath, boolean replaceValues) {
        Manifest manifest = ManifestFileUtil.readManifest(file);
        Attributes mainAttributes = manifest.getMainAttributes();
        if (mainClass != null) {
            mainAttributes.put(Attributes.Name.MAIN_CLASS, mainClass);
        } else if (replaceValues) {
            mainAttributes.remove(Attributes.Name.MAIN_CLASS);
        }
        if (classpath != null && !classpath.isEmpty()) {
            List<String> updatedClasspath;
            if (replaceValues) {
                updatedClasspath = classpath;
            } else {
                updatedClasspath = new ArrayList<String>();
                String oldClasspath = (String)mainAttributes.get(Attributes.Name.CLASS_PATH);
                if (!StringUtil.isEmpty((String)oldClasspath)) {
                    updatedClasspath.addAll(StringUtil.split((String)oldClasspath, (String)" "));
                }
                for (String path : classpath) {
                    if (updatedClasspath.contains(path)) continue;
                    updatedClasspath.add(path);
                }
            }
            mainAttributes.put(Attributes.Name.CLASS_PATH, StringUtil.join(updatedClasspath, (String)" "));
        } else if (replaceValues) {
            mainAttributes.remove(Attributes.Name.CLASS_PATH);
        }
        ManifestBuilder.setVersionAttribute((Attributes)mainAttributes);
        try {
            OutputStream outputStream = file.getOutputStream(ManifestFileUtil.class);
            try {
                manifest.write(outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    public static ManifestFileConfiguration createManifestFileConfiguration(@NotNull VirtualFile manifestFile) {
        if (manifestFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ManifestFileUtil.createManifestFileConfiguration must not be null");
        }
        String path = manifestFile.getPath();
        Manifest manifest = ManifestFileUtil.readManifest(manifestFile);
        String mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        String classpathText = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        ArrayList classpath = new ArrayList();
        if (classpathText != null) {
            classpath.addAll(StringUtil.split((String)classpathText, (String)" "));
        }
        ManifestFileConfiguration manifestFileConfiguration = new ManifestFileConfiguration(path, classpath, mainClass);
        if (manifestFileConfiguration == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/ManifestFileUtil.createManifestFileConfiguration must not return null");
        }
        return manifestFileConfiguration;
    }

    public static List<String> getClasspathForElements(List<? extends PackagingElement<?>> elements, PackagingElementResolvingContext context, ArtifactType artifactType) {
        final ArrayList<String> classpath = new ArrayList<String>();
        PackagingElementProcessor processor = new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ManifestFileUtil$2.process must not be null");
                }
                if (path == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/ManifestFileUtil$2.process must not be null");
                }
                if (element instanceof FileCopyPackagingElement) {
                    String fileName = ((FileCopyPackagingElement)element).getOutputFileName();
                    classpath.add(DeploymentUtil.appendToPath((String)path.getPathString(), (String)fileName));
                } else if (element instanceof DirectoryCopyPackagingElement) {
                    classpath.add(path.getPathString());
                } else if (element instanceof ArchivePackagingElement) {
                    String archiveName = ((ArchivePackagingElement)element).getName();
                    classpath.add(DeploymentUtil.appendToPath((String)path.getPathString(), (String)archiveName));
                }
                return true;
            }
        };
        for (PackagingElement<?> element : elements) {
            ArtifactUtil.processPackagingElements(element, null, processor, context, true, artifactType);
        }
        return classpath;
    }

    @Nullable
    public static VirtualFile showDialogAndCreateManifest(ArtifactEditorContext context, CompositePackagingElement<?> element) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle("Select Directory for META-INF/MANIFEST.MF file");
        VirtualFile directory = ManifestFileUtil.suggestManifestFileDirectory(element, (PackagingElementResolvingContext)context, context.getArtifactType());
        final VirtualFile[] files = FileChooser.chooseFiles((Project)context.getProject(), (FileChooserDescriptor)descriptor, (VirtualFile)directory);
        if (files.length != 1) {
            return null;
        }
        final Ref exc = Ref.create(null);
        VirtualFile file = (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(Result<VirtualFile> result) {
                VirtualFile dir = files[0];
                try {
                    if (!dir.getName().equals(MANIFEST_DIR_NAME)) {
                        VirtualFile newDir = dir.findChild(MANIFEST_DIR_NAME);
                        if (newDir == null) {
                            newDir = dir.createChildDirectory((Object)this, MANIFEST_DIR_NAME);
                        }
                        dir = newDir;
                    }
                    result.setResult((Object)dir.createChildData((Object)this, MANIFEST_FILE_NAME));
                }
                catch (IOException e) {
                    exc.set((Object)e);
                }
            }
        }.execute().getResultObject();
        IOException exception = (IOException)exc.get();
        if (exception != null) {
            LOG.info((Throwable)exception);
            Messages.showErrorDialog((Project)context.getProject(), (String)exception.getMessage(), (String)CommonBundle.getErrorTitle());
            return null;
        }
        return file;
    }

    public static void addManifestFileToLayout(final @NotNull String path, final @NotNull ArtifactEditorContext context, final @NotNull CompositePackagingElement<?> element) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ManifestFileUtil.addManifestFileToLayout must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/ManifestFileUtil.addManifestFileToLayout must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/ManifestFileUtil.addManifestFileToLayout must not be null");
        }
        context.editLayout(context.getArtifact(), new Runnable(){

            @Override
            public void run() {
                VirtualFile file = ManifestFileUtil.findManifestFile(element, (PackagingElementResolvingContext)context, context.getArtifactType());
                if (file == null || !FileUtil.pathsEqual((String)file.getPath(), (String)path)) {
                    PackagingElementFactory.getInstance().addFileCopy(element, MANIFEST_DIR_NAME, path, MANIFEST_FILE_NAME);
                }
            }
        });
    }
}

