/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileOrDirectoryCopyPackagingElement<T extends FileOrDirectoryCopyPackagingElement>
extends PackagingElement<T> {
    @NonNls
    public static final String PATH_ATTRIBUTE = "path";
    protected String myFilePath;

    public FileOrDirectoryCopyPackagingElement(PackagingElementType type) {
        super(type);
    }

    protected FileOrDirectoryCopyPackagingElement(PackagingElementType type, String filePath) {
        super(type);
        this.myFilePath = filePath;
    }

    @Nullable
    public VirtualFile findFile() {
        return LocalFileSystem.getInstance().findFileByPath(this.myFilePath);
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/FileOrDirectoryCopyPackagingElement.isEqualTo must not be null");
        }
        return element instanceof FileOrDirectoryCopyPackagingElement && this.myFilePath != null && this.myFilePath.equals(((FileOrDirectoryCopyPackagingElement)element).getFilePath());
    }

    @Attribute(value="path")
    public String getFilePath() {
        return this.myFilePath;
    }

    public void setFilePath(String filePath) {
        this.myFilePath = filePath;
    }
}

