/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PlainArtifactType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ArtifactElementType
extends ComplexPackagingElementType<ArtifactPackagingElement> {
    public static final ArtifactElementType ARTIFACT_ELEMENT_TYPE = new ArtifactElementType();

    ArtifactElementType() {
        super("artifact", CompilerBundle.message((String)"element.type.name.artifact", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return PlainArtifactType.ARTIFACT_ICON;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ArtifactElementType.canCreate must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/ArtifactElementType.canCreate must not be null");
        }
        return !ArtifactElementType.getAvailableArtifacts(context, artifact).isEmpty();
    }

    @NotNull
    public List<? extends ArtifactPackagingElement> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ArtifactElementType.chooseAndCreate must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/ArtifactElementType.chooseAndCreate must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/ArtifactElementType.chooseAndCreate must not be null");
        }
        Project project = context.getProject();
        List artifacts = context.chooseArtifacts(ArtifactElementType.getAvailableArtifacts(context, artifact), CompilerBundle.message((String)"dialog.title.choose.artifacts", (Object[])new Object[0]));
        ArrayList<ArtifactPackagingElement> elements = new ArrayList<ArtifactPackagingElement>();
        for (Artifact selected : artifacts) {
            elements.add(new ArtifactPackagingElement(project, ArtifactPointerManager.getInstance((Project)project).createPointer(selected, context.getArtifactModel())));
        }
        ArrayList<ArtifactPackagingElement> arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/ArtifactElementType.chooseAndCreate must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static List<? extends Artifact> getAvailableArtifacts(final @NotNull ArtifactEditorContext context, final @NotNull Artifact artifact) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ArtifactElementType.getAvailableArtifacts must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/ArtifactElementType.getAvailableArtifacts must not be null");
        }
        final HashSet<Artifact> result = new HashSet<Artifact>(Arrays.asList(context.getArtifactModel().getArtifacts()));
        ArtifactUtil.processPackagingElements(artifact, ARTIFACT_ELEMENT_TYPE, new Processor<ArtifactPackagingElement>(){

            public boolean process(ArtifactPackagingElement artifactPackagingElement) {
                result.remove(artifactPackagingElement.findArtifact((PackagingElementResolvingContext)context));
                return true;
            }
        }, (PackagingElementResolvingContext)context, true);
        result.remove(artifact);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Artifact another = (Artifact)iterator.next();
            boolean notContainThis = ArtifactUtil.processPackagingElements(another, ARTIFACT_ELEMENT_TYPE, new Processor<ArtifactPackagingElement>(){

                public boolean process(ArtifactPackagingElement element) {
                    return !artifact.getName().equals(element.getArtifactName());
                }
            }, (PackagingElementResolvingContext)context, true);
            if (notContainThis) continue;
            iterator.remove();
        }
        ArrayList<Artifact> list = new ArrayList<Artifact>(result);
        Collections.sort(list, ArtifactManager.ARTIFACT_COMPARATOR);
        ArrayList<Artifact> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/ArtifactElementType.getAvailableArtifacts must not return null");
        }
        return arrayList;
    }

    @NotNull
    public ArtifactPackagingElement createEmpty(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/ArtifactElementType.createEmpty must not be null");
        }
        ArtifactPackagingElement artifactPackagingElement = new ArtifactPackagingElement(project);
        if (artifactPackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/ArtifactElementType.createEmpty must not return null");
        }
        return artifactPackagingElement;
    }

    public String getShowContentActionText() {
        return "Show Content of Included Artifacts";
    }
}

