/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.facet.impl.DefaultFacetsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultPackagingElementResolvingContext
implements PackagingElementResolvingContext {
    private final Project myProject;
    private final DefaultModulesProvider myModulesProvider;

    public DefaultPackagingElementResolvingContext(Project project) {
        this.myProject = project;
        this.myModulesProvider = new DefaultModulesProvider(this.myProject);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/DefaultPackagingElementResolvingContext.getProject must not return null");
        }
        return project;
    }

    @NotNull
    public ArtifactModel getArtifactModel() {
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
        if (artifactManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/DefaultPackagingElementResolvingContext.getArtifactModel must not return null");
        }
        return artifactManager;
    }

    @NotNull
    public ModulesProvider getModulesProvider() {
        DefaultModulesProvider defaultModulesProvider = this.myModulesProvider;
        if (defaultModulesProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/DefaultPackagingElementResolvingContext.getModulesProvider must not return null");
        }
        return defaultModulesProvider;
    }

    @NotNull
    public FacetsProvider getFacetsProvider() {
        FacetsProvider facetsProvider = DefaultFacetsProvider.INSTANCE;
        if (facetsProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/DefaultPackagingElementResolvingContext.getFacetsProvider must not return null");
        }
        return facetsProvider;
    }

    public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
        if (level == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/DefaultPackagingElementResolvingContext.findLibrary must not be null");
        }
        if (libraryName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/DefaultPackagingElementResolvingContext.findLibrary must not be null");
        }
        return DefaultPackagingElementResolvingContext.findLibrary(this.myProject, level, libraryName);
    }

    @Nullable
    public static Library findLibrary(Project project, String level, String libraryName) {
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, project);
        return table != null ? table.getLibraryByName(libraryName) : null;
    }
}

