/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.IconLoader;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiFile;
import java.util.Set;
import javax.swing.Icon;

public class LibraryNode
extends PackageDependenciesNode {
    private static final Icon LIB_ICON_OPEN = IconLoader.getIcon((String)"/nodes/ppLibOpen.png");
    private static final Icon LIB_ICON_CLOSED = IconLoader.getIcon((String)"/nodes/ppLibClosed.png");
    private static final Icon JDK_ICON_OPEN = IconLoader.getIcon((String)"/nodes/ppJdkOpen.png");
    private static final Icon JDK_ICON_CLOSED = IconLoader.getIcon((String)"/nodes/ppJdkClosed.png");
    private final OrderEntry myLibraryOrJdk;

    public LibraryNode(OrderEntry libraryOrJdk) {
        this.myLibraryOrJdk = libraryOrJdk;
    }

    @Override
    public void fillFiles(Set<PsiFile> set, boolean recursively) {
        super.fillFiles(set, recursively);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            PackageDependenciesNode child = (PackageDependenciesNode)this.getChildAt(i);
            child.fillFiles(set, true);
        }
    }

    @Override
    public String toString() {
        return this.myLibraryOrJdk.getPresentableName();
    }

    @Override
    public int getWeight() {
        return 2;
    }

    public boolean equals(Object o) {
        if (this.isEquals()) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryNode)) {
            return false;
        }
        LibraryNode libraryNode = (LibraryNode)o;
        return this.myLibraryOrJdk.equals(libraryNode.myLibraryOrJdk);
    }

    public int hashCode() {
        return this.myLibraryOrJdk.hashCode();
    }

    @Override
    public Icon getOpenIcon() {
        return this.myLibraryOrJdk instanceof JdkOrderEntry ? JDK_ICON_OPEN : LIB_ICON_OPEN;
    }

    @Override
    public Icon getClosedIcon() {
        return this.myLibraryOrJdk instanceof JdkOrderEntry ? JDK_ICON_CLOSED : LIB_ICON_CLOSED;
    }
}

