/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.FilePatternPackageSet;
import com.intellij.util.Icons;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class DirectoryNode
extends PackageDependenciesNode {
    private final String myDirName;
    private final PsiDirectory myDirectory;
    private DirectoryNode myCompactedDirNode;
    private DirectoryNode myWrapper;
    private boolean myCompactPackages = true;
    private String myFQName = null;

    public DirectoryNode(PsiDirectory aDirectory, boolean compactPackages, boolean showFQName) {
        this.myDirectory = aDirectory;
        VirtualFile directory = this.myDirectory.getVirtualFile();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myDirectory.getProject()).getFileIndex();
        String dirName = aDirectory.getName();
        if (showFQName) {
            VirtualFile sourceRoot;
            VirtualFile contentRoot = index.getContentRootForFile(directory);
            this.myFQName = contentRoot != null ? (directory == contentRoot ? dirName : (directory == (sourceRoot = index.getSourceRootForFile(directory)) ? dirName : (sourceRoot != null ? VfsUtil.getRelativePath((VirtualFile)directory, (VirtualFile)sourceRoot, (char)'/') : VfsUtil.getRelativePath((VirtualFile)directory, (VirtualFile)contentRoot, (char)'/')))) : FilePatternPackageSet.getLibRelativePath((VirtualFile)directory, (ProjectFileIndex)index);
            dirName = this.myFQName;
        }
        this.myDirName = dirName;
        this.myCompactPackages = compactPackages;
    }

    @Override
    public void fillFiles(Set<PsiFile> set, boolean recursively) {
        super.fillFiles(set, recursively);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            PackageDependenciesNode child = (PackageDependenciesNode)this.getChildAt(i);
            if (!(child instanceof FileNode) && !recursively) continue;
            child.fillFiles(set, true);
        }
    }

    @Override
    public String toString() {
        if (this.myFQName != null) {
            return this.myFQName;
        }
        if (this.myCompactPackages && this.myCompactedDirNode != null) {
            return this.myDirName + "/" + this.myCompactedDirNode.getDirName();
        }
        return this.myDirName;
    }

    public String getDirName() {
        if (this.myDirectory == null || !this.myDirectory.isValid()) {
            return "";
        }
        if (this.myCompactPackages && this.myCompactedDirNode != null) {
            return this.myDirectory.getName() + "/" + this.myCompactedDirNode.getDirName();
        }
        return this.myDirName;
    }

    public String getFQName() {
        VirtualFile contentRoot;
        StringBuffer buf = new StringBuffer();
        Project project = this.myDirectory.getProject();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile directory = this.myDirectory.getVirtualFile();
        if (directory == (contentRoot = index.getContentRootForFile(directory))) {
            return "";
        }
        if (contentRoot == null) {
            return "";
        }
        while (directory != null && contentRoot != directory) {
            buf.insert(0, directory.getName() + "/");
            directory = directory.getParent();
        }
        return buf.toString();
    }

    @Override
    public PsiElement getPsiElement() {
        return this.myDirectory;
    }

    @Override
    public int getWeight() {
        return 3;
    }

    public boolean equals(Object o) {
        if (this.isEquals()) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectoryNode)) {
            return false;
        }
        DirectoryNode packageNode = (DirectoryNode)o;
        return this.toString().equals(packageNode.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public Icon getOpenIcon() {
        return Icons.PACKAGE_OPEN_ICON;
    }

    @Override
    public Icon getClosedIcon() {
        return Icons.PACKAGE_ICON;
    }

    public void setCompactedDirNode(DirectoryNode compactedDirNode) {
        if (this.myCompactedDirNode != null) {
            this.myCompactedDirNode.myWrapper = null;
        }
        this.myCompactedDirNode = compactedDirNode;
        if (this.myCompactedDirNode != null) {
            this.myCompactedDirNode.myWrapper = this;
        }
    }

    public DirectoryNode getWrapper() {
        return this.myWrapper;
    }

    @Nullable
    public DirectoryNode getCompactedDirNode() {
        return this.myCompactPackages ? this.myCompactedDirNode : null;
    }

    public void removeUpReference() {
        this.myWrapper = null;
    }

    @Override
    public boolean isValid() {
        return this.myDirectory != null && this.myDirectory.isValid();
    }

    @Override
    public boolean canNavigate() {
        return false;
    }

    @Override
    public String getComment() {
        if (this.myDirectory != null && this.myDirectory.isValid()) {
            return ProjectViewDirectoryHelper.getInstance(this.myDirectory.getProject()).getLocationString(this.myDirectory);
        }
        return super.getComment();
    }

    @Override
    public boolean canSelectInLeftTree(Map<PsiFile, Set<PsiFile>> deps) {
        Set<PsiFile> files = deps.keySet();
        for (PsiFile file : files) {
            if (file.getContainingDirectory() != this.myDirectory) continue;
            return true;
        }
        return false;
    }
}

