/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DependencyValidationManager", storages={@Storage(id="other", file="$PROJECT_FILE$")})
public class DependencyValidationManagerImpl
extends DependencyValidationManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packageDependencies.DependencyValidationManagerImpl");
    private final List<DependencyRule> myRules = new ArrayList<DependencyRule>();
    public boolean SKIP_IMPORT_STATEMENTS = false;
    private final Project myProject;
    private ContentManager myContentManager;
    @NonNls
    private static final String DENY_RULE_KEY = "deny_rule";
    @NonNls
    private static final String FROM_SCOPE_KEY = "from_scope";
    @NonNls
    private static final String TO_SCOPE_KEY = "to_scope";
    @NonNls
    private static final String IS_DENY_KEY = "is_deny";
    @NonNls
    private static final String UNNAMED_SCOPE = "unnamed_scope";
    @NonNls
    private static final String VALUE = "value";
    private static final Icon SHARED_SCOPES = IconLoader.getIcon((String)"/ide/sharedScope.png");
    private final Map<String, PackageSet> myUnnamedScopes = new HashMap<String, PackageSet>();

    public DependencyValidationManagerImpl(final Project project) {
        this.myProject = project;
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)DependencyValidationManagerImpl.this.myProject);
                if (toolWindowManager == null) {
                    return;
                }
                ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.DEPENDENCIES, true, ToolWindowAnchor.BOTTOM, (Disposable)project);
                DependencyValidationManagerImpl.this.myContentManager = toolWindow.getContentManager();
                toolWindow.setIcon(IconLoader.getIcon((String)"/general/toolWindowInspection.png"));
                new ContentManagerWatcher(toolWindow, DependencyValidationManagerImpl.this.myContentManager);
            }
        });
    }

    @NotNull
    public List<NamedScope> getPredefinedScopes() {
        ArrayList<NamedScope> predifinedScopes = new ArrayList<NamedScope>();
        CustomScopesProvider[] scopesProviders = (CustomScopesProvider[])this.myProject.getExtensions(CustomScopesProvider.CUSTOM_SCOPES_PROVIDER);
        if (scopesProviders != null) {
            for (CustomScopesProvider scopesProvider : scopesProviders) {
                predifinedScopes.addAll(scopesProvider.getCustomScopes());
            }
        }
        ArrayList<NamedScope> arrayList = predifinedScopes;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packageDependencies/DependencyValidationManagerImpl.getPredefinedScopes must not return null");
        }
        return arrayList;
    }

    public boolean hasRules() {
        return !this.myRules.isEmpty();
    }

    @Nullable
    public DependencyRule getViolatorDependencyRule(PsiFile from, PsiFile to) {
        for (DependencyRule dependencyRule : this.myRules) {
            if (!dependencyRule.isForbiddenToUse(from, to)) continue;
            return dependencyRule;
        }
        return null;
    }

    @NotNull
    public DependencyRule[] getViolatorDependencyRules(PsiFile from, PsiFile to) {
        ArrayList<DependencyRule> result = new ArrayList<DependencyRule>();
        for (DependencyRule dependencyRule : this.myRules) {
            if (!dependencyRule.isForbiddenToUse(from, to)) continue;
            result.add(dependencyRule);
        }
        DependencyRule[] dependencyRuleArray = result.toArray(new DependencyRule[result.size()]);
        if (dependencyRuleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packageDependencies/DependencyValidationManagerImpl.getViolatorDependencyRules must not return null");
        }
        return dependencyRuleArray;
    }

    @NotNull
    public DependencyRule[] getApplicableRules(PsiFile file) {
        ArrayList<DependencyRule> result = new ArrayList<DependencyRule>();
        for (DependencyRule dependencyRule : this.myRules) {
            if (!dependencyRule.isApplicable(file)) continue;
            result.add(dependencyRule);
        }
        DependencyRule[] dependencyRuleArray = result.toArray(new DependencyRule[result.size()]);
        if (dependencyRuleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packageDependencies/DependencyValidationManagerImpl.getApplicableRules must not return null");
        }
        return dependencyRuleArray;
    }

    public boolean skipImportStatements() {
        return this.SKIP_IMPORT_STATEMENTS;
    }

    public void setSkipImportStatements(boolean skip) {
        this.SKIP_IMPORT_STATEMENTS = skip;
    }

    public Map<String, PackageSet> getUnnamedScopes() {
        return this.myUnnamedScopes;
    }

    public DependencyRule[] getAllRules() {
        return this.myRules.toArray(new DependencyRule[this.myRules.size()]);
    }

    public void removeAllRules() {
        this.myRules.clear();
    }

    public void addRule(DependencyRule rule) {
        this.appendUnnamedScope(rule.getFromScope());
        this.appendUnnamedScope(rule.getToScope());
        this.myRules.add(rule);
    }

    private void appendUnnamedScope(NamedScope fromScope) {
        PackageSet packageSet;
        if (this.getScope(fromScope.getName()) == null && (packageSet = fromScope.getValue()) != null && !this.myUnnamedScopes.containsKey(packageSet.getText())) {
            this.myUnnamedScopes.put(packageSet.getText(), packageSet);
        }
    }

    public void addContent(Content content) {
        this.myContentManager.addContent(content);
        this.myContentManager.setSelectedContent(content);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.DEPENDENCIES).activate(null);
    }

    public void closeContent(Content content) {
        this.myContentManager.removeContent(content, true);
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"shared.scopes.node.text", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return SHARED_SCOPES;
    }

    public void loadState(Element element) {
        try {
            DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        }
        catch (InvalidDataException e) {
            LOG.info((Throwable)e);
        }
        super.loadState(element);
        this.myUnnamedScopes.clear();
        List unnamedScopes = element.getChildren(UNNAMED_SCOPE);
        PackageSetFactory packageSetFactory = PackageSetFactory.getInstance();
        for (Object unnamedScope : unnamedScopes) {
            try {
                String packageSet = ((Element)unnamedScope).getAttributeValue(VALUE);
                this.myUnnamedScopes.put(packageSet, packageSetFactory.compile(packageSet));
            }
            catch (ParsingException e) {}
        }
        this.myRules.clear();
        List rules = element.getChildren(DENY_RULE_KEY);
        for (Object rule1 : rules) {
            DependencyRule rule = this.readRule((Element)rule1);
            if (rule == null) continue;
            this.addRule(rule);
        }
    }

    public Element getState() {
        Element element = super.getState();
        try {
            DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        }
        catch (WriteExternalException e) {
            LOG.info((Throwable)e);
        }
        ArrayList<String> unnamedScopes = new ArrayList<String>(this.myUnnamedScopes.keySet());
        Collections.sort(unnamedScopes);
        for (String unnamedScope : unnamedScopes) {
            Element unnamedElement = new Element(UNNAMED_SCOPE);
            unnamedElement.setAttribute(VALUE, unnamedScope);
            element.addContent(unnamedElement);
        }
        for (DependencyRule rule : this.myRules) {
            Element ruleElement = DependencyValidationManagerImpl.writeRule(rule);
            if (ruleElement == null) continue;
            element.addContent(ruleElement);
        }
        return element;
    }

    @Nullable
    public NamedScope getScope(@Nullable String name) {
        PackageSet packageSet;
        NamedScope scope = super.getScope(name);
        if (scope == null && (packageSet = this.myUnnamedScopes.get(name)) != null) {
            return new NamedScope.UnnamedScope(packageSet);
        }
        if (scope == null && Comparing.strEqual((String)name, (String)"Project")) {
            return super.getScope("All");
        }
        return scope;
    }

    @Nullable
    private static Element writeRule(DependencyRule rule) {
        NamedScope fromScope = rule.getFromScope();
        NamedScope toScope = rule.getToScope();
        if (fromScope == null || toScope == null) {
            return null;
        }
        Element ruleElement = new Element(DENY_RULE_KEY);
        ruleElement.setAttribute(FROM_SCOPE_KEY, fromScope.getName());
        ruleElement.setAttribute(TO_SCOPE_KEY, toScope.getName());
        ruleElement.setAttribute(IS_DENY_KEY, Boolean.valueOf(rule.isDenyRule()).toString());
        return ruleElement;
    }

    @Nullable
    private DependencyRule readRule(Element ruleElement) {
        String fromScope = ruleElement.getAttributeValue(FROM_SCOPE_KEY);
        String toScope = ruleElement.getAttributeValue(TO_SCOPE_KEY);
        String denyRule = ruleElement.getAttributeValue(IS_DENY_KEY);
        if (fromScope == null || toScope == null || denyRule == null) {
            return null;
        }
        NamedScope fromNamedScope = this.getScope(fromScope);
        NamedScope toNamedScope = this.getScope(toScope);
        if (fromNamedScope == null || toNamedScope == null) {
            return null;
        }
        return new DependencyRule(fromNamedScope, toNamedScope, Boolean.valueOf(denyRule).booleanValue());
    }
}

