/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DefaultScopesProvider
implements CustomScopesProvider {
    private NamedScope myProblemsScope;
    private final Project myProject;

    public static DefaultScopesProvider getInstance(Project project) {
        for (CustomScopesProvider provider : (CustomScopesProvider[])Extensions.getExtensions((ExtensionPointName)CUSTOM_SCOPES_PROVIDER, (AreaInstance)project)) {
            if (!(provider instanceof DefaultScopesProvider)) continue;
            return (DefaultScopesProvider)provider;
        }
        return null;
    }

    public DefaultScopesProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<NamedScope> getCustomScopes() {
        ArrayList<NamedScope> list = new ArrayList<NamedScope>();
        list.add(this.getProblemsScope());
        list.add(DefaultScopesProvider.getAllScope());
        ArrayList<NamedScope> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packageDependencies/DefaultScopesProvider.getCustomScopes must not return null");
        }
        return arrayList;
    }

    public static NamedScope getAllScope() {
        return NamedScopeHolder.myAllScope;
    }

    public NamedScope getProblemsScope() {
        if (this.myProblemsScope == null) {
            this.myProblemsScope = new NamedScope(IdeBundle.message((String)"predefined.scope.problems.name", (Object[])new Object[0]), new PackageSet(){

                public boolean contains(PsiFile file, NamedScopesHolder holder) {
                    return file.getProject() == DefaultScopesProvider.this.myProject && WolfTheProblemSolver.getInstance((Project)DefaultScopesProvider.this.myProject).isProblemFile(file.getVirtualFile());
                }

                public PackageSet createCopy() {
                    return this;
                }

                public String getText() {
                    return "file:*//*";
                }

                public int getNodePriority() {
                    return 1;
                }
            });
        }
        return this.myProblemsScope;
    }

    private static class NamedScopeHolder {
        private static final NamedScope myAllScope = new NamedScope("All", new PackageSet(){

            public boolean contains(PsiFile file, NamedScopesHolder holder) {
                return true;
            }

            public PackageSet createCopy() {
                return this;
            }

            public String getText() {
                return "file:*//*";
            }

            public int getNodePriority() {
                return 0;
            }
        });

        private NamedScopeHolder() {
        }
    }
}

