/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.SplittingUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LabelUI;

public class TextPanel
extends JLabel {
    private String myText = "";
    private final String[] myPossibleStrings;

    public TextPanel(boolean shouldShowTooltip, String ... possibleStrings) {
        this.myPossibleStrings = possibleStrings;
        if (shouldShowTooltip) {
            this.addMouseListener(new MyMouseListener());
        }
    }

    private static String splitText(JLabel label, String text, int widthLimit) {
        FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
        String[] lines = SplittingUtil.splitText(text, fontMetrics, widthLimit, ' ');
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i > 0) {
                result.append('\n');
            }
            result.append(line);
        }
        return result.toString();
    }

    @Override
    public final void setText(String text) {
        super.setText(text);
        this.myText = text;
    }

    @Override
    public void setDisplayedMnemonic(int key) {
    }

    @Override
    public void setDisplayedMnemonicIndex(int index) throws IllegalArgumentException {
        super.setDisplayedMnemonicIndex(-1);
    }

    @Override
    public final Dimension getPreferredSize() {
        int max = 0;
        for (String possibleString : this.myPossibleStrings) {
            max = Math.max(max, this.getFontMetrics(this.getFont()).stringWidth(possibleString));
        }
        return new Dimension(20 + max, this.getMinimumSize().height);
    }

    private final class MyMouseListener
    extends MouseAdapter {
        private LightweightHint myHint;

        private MyMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.myHint != null) {
                this.myHint.hide();
                this.myHint = null;
            }
            int widthLimit = TextPanel.this.getSize().width - 20;
            if (TextPanel.this.getFontMetrics(TextPanel.this.getFont()).stringWidth(TextPanel.this.myText) < widthLimit) {
                return;
            }
            JLabel label = new JLabel();
            label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            label.setForeground(Color.black);
            label.setBackground(HintUtil.INFORMATION_COLOR);
            label.setOpaque(true);
            label.setUI((LabelUI)new MultiLineLabelUI());
            JLayeredPane layeredPane = TextPanel.this.getRootPane().getLayeredPane();
            label.setText(TextPanel.splitText(label, TextPanel.this.myText, layeredPane.getWidth() - 10));
            Point p = SwingUtilities.convertPoint(TextPanel.this, 1, TextPanel.this.getHeight() - 1, layeredPane);
            p.y -= label.getPreferredSize().height;
            this.myHint = new LightweightHint(label);
            this.myHint.show(layeredPane, p.x, p.y, null);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.myHint != null) {
                this.myHint.hide();
                this.myHint = null;
            }
        }
    }
}

