/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.util.MinimizeButton;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;

public class ProcessPopup {
    private final VerticalBox myProcessBox = new VerticalBox();
    private final InfoAndProgressPanel myProgressPanel;
    private JBPopup myPopup;
    private JPanel myActiveFocusedContent;
    private JComponent myActiveContentComponent;
    private final JLabel myInactiveContentComponent;
    private final Wrapper myRootContent = new Wrapper();
    private final Set<InlineProgressIndicator> myIndicators = new HashSet<InlineProgressIndicator>();

    public ProcessPopup(InfoAndProgressPanel progressPanel) {
        this.myProgressPanel = progressPanel;
        this.buildActiveContent();
        this.myInactiveContentComponent = new JLabel(IdeBundle.message((String)"progress.window.empty.text", (Object[])new Object[0]), null, 0){

            @Override
            public Dimension getPreferredSize() {
                return ProcessPopup.this.getEmptyPreferredSize();
            }
        };
        this.myInactiveContentComponent.setFocusable(true);
        this.switchToPassive();
    }

    public void addIndicator(InlineProgressIndicator indicator) {
        this.myIndicators.add(indicator);
        this.myProcessBox.add((Component)indicator.getComponent());
        this.myProcessBox.add(Box.createVerticalStrut(4));
        this.swithToActive();
        this.revalidateAll();
    }

    public void removeIndicator(InlineProgressIndicator indicator) {
        if (indicator.getComponent().getParent() != this.myProcessBox) {
            return;
        }
        this.removeExtraSeparator(indicator);
        this.myProcessBox.remove((Component)indicator.getComponent());
        this.myIndicators.remove(indicator);
        this.switchToPassive();
        this.revalidateAll();
    }

    private void swithToActive() {
        if (this.myActiveContentComponent.getParent() == null && this.myIndicators.size() > 0) {
            this.myRootContent.removeAll();
            this.myRootContent.setContent(this.myActiveContentComponent);
        }
    }

    private void switchToPassive() {
        if (this.myInactiveContentComponent.getParent() == null && this.myIndicators.size() == 0) {
            this.myRootContent.removeAll();
            this.myRootContent.setContent((JComponent)this.myInactiveContentComponent);
        }
    }

    private void removeExtraSeparator(InlineProgressIndicator indicator) {
        Object[] all = this.myProcessBox.getComponents();
        int index = ArrayUtil.indexOf((Object[])all, (Object)indicator.getComponent());
        if (index == -1) {
            return;
        }
        if (index == 0 && all.length > 1) {
            this.myProcessBox.remove(1);
        } else if (all.length > 2 && index < all.length - 1) {
            this.myProcessBox.remove(index + 1);
        }
        this.myProcessBox.remove((Component)indicator.getComponent());
    }

    public void show() {
        JComponent toFocus = this.myRootContent.getTargetComponent() == this.myActiveContentComponent ? this.myActiveFocusedContent : this.myInactiveContentComponent;
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myRootContent, toFocus);
        builder.addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                ProcessPopup.this.myProgressPanel.hideProcessPopup();
            }
        });
        builder.setMovable(true);
        builder.setResizable(true);
        builder.setTitle(IdeBundle.message((String)"progress.window.title", (Object[])new Object[0]));
        builder.setDimensionServiceKey(null, "ProcessPopupWindow", true);
        builder.setMinSize(this.getMinSize());
        builder.setCancelOnClickOutside(false);
        builder.setRequestFocus(true);
        builder.setBelongsToGlobalPopupStack(false);
        builder.setCancelButton((IconButton)new MinimizeButton("Hide"));
        this.myPopup = builder.createPopup();
        this.myPopup.showInCenterOf((Component)this.myProgressPanel.getRootPane());
    }

    private void buildActiveContent() {
        this.myActiveFocusedContent = new ActiveContent();
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)this.myProcessBox, "North");
        this.myActiveFocusedContent.add((Component)wrapper, "Center");
        JScrollPane scrolls = new JScrollPane(this.myActiveFocusedContent){

            @Override
            public Dimension getPreferredSize() {
                if (ProcessPopup.this.myProcessBox.getComponentCount() > 0) {
                    return super.getPreferredSize();
                }
                return ProcessPopup.this.getEmptyPreferredSize();
            }
        };
        scrolls.getViewport().setBackground(this.myActiveFocusedContent.getBackground());
        scrolls.setBorder(null);
        this.myActiveContentComponent = scrolls;
    }

    private Dimension getEmptyPreferredSize() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        size.width = (int)((double)size.width * 0.3);
        size.height = (int)((double)size.height * 0.3);
        return size;
    }

    private Dimension getMinSize() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        size.width = (int)((double)size.width * 0.1);
        size.height = (int)((double)size.height * 0.1);
        return size;
    }

    public void hide() {
        if (this.myPopup != null) {
            JBPopup popup = this.myPopup;
            this.myPopup = null;
            popup.cancel();
        }
    }

    public boolean isShowing() {
        return this.myPopup != null;
    }

    private void revalidateAll() {
        this.myRootContent.revalidate();
        this.myRootContent.repaint();
    }

    private class ActiveContent
    extends JPanel
    implements Scrollable {
        private final JLabel myLabel;

        public ActiveContent() {
            super(new BorderLayout());
            this.myLabel = new JLabel("XXX");
            this.setBorder(DialogWrapper.ourDefaultBorder);
            this.setFocusable(true);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.myLabel.getPreferredSize().height;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.myLabel.getPreferredSize().height;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

