/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.WatermarkIcon;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;

class BaseLabel
extends JLabel {
    protected static final int TAB_SHIFT = 2;
    protected ToolWindowContentUi myUi;
    private Color myActiveFg;
    private Color myPassiveFg;
    private final boolean myBold;

    public BaseLabel(ToolWindowContentUi ui, boolean bold) {
        this.myUi = ui;
        this.setOpaque(false);
        this.setActiveFg(Color.white);
        this.setPassiveFg(Color.white);
        this.myBold = bold;
        this.updateFont();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateFont();
    }

    private void updateFont() {
        if (this.myBold) {
            this.setFont(UIUtil.getLabelFont().deriveFont(1));
        }
    }

    public void setActiveFg(Color fg) {
        this.myActiveFg = fg;
    }

    public void setPassiveFg(Color passiveFg) {
        this.myPassiveFg = passiveFg;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.setForeground(this.myUi.myWindow.isActive() ? this.myActiveFg : this.myPassiveFg);
        super.paintComponent(g);
    }

    protected void updateTextAndIcon(Content content, boolean isSelected) {
        if (content == null) {
            this.setText(null);
            this.setIcon(null);
        } else {
            this.setText(content.getDisplayName());
            this.setActiveFg(isSelected ? Color.white : new Color(188, 195, 219));
            this.setPassiveFg(isSelected ? Color.white : new Color(213, 210, 202));
            this.setToolTipText(content.getDescription());
            boolean show = Boolean.TRUE.equals(content.getUserData(ToolWindow.SHOW_CONTENT_ICON));
            if (show) {
                if (isSelected) {
                    this.setIcon(content.getIcon());
                } else {
                    this.setIcon((Icon)(content.getIcon() != null ? new WatermarkIcon(content.getIcon(), 0.5f) : null));
                }
            } else {
                this.setIcon(null);
            }
        }
    }

    public Content getContent() {
        return null;
    }
}

