/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.Patches;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManagerListener;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.AWTUtilitiesWrapper;
import com.intellij.openapi.wm.impl.CommandProcessor;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.WindowWatcher;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.examples.WindowUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WindowManagerImpl
extends WindowManagerEx
implements ApplicationComponent,
NamedJDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.WindowManagerImpl");
    private static boolean ourAlphaModeLibraryLoaded;
    @NonNls
    private static final String FOCUSED_WINDOW_PROPERTY_NAME = "focusedWindow";
    @NonNls
    private static final String X_ATTR = "x";
    @NonNls
    private static final String FRAME_ELEMENT = "frame";
    @NonNls
    private static final String Y_ATTR = "y";
    @NonNls
    private static final String WIDTH_ATTR = "width";
    @NonNls
    private static final String HEIGHT_ATTR = "height";
    @NonNls
    private static final String EXTENDED_STATE_ATTR = "extended-state";
    private Boolean myAlphaModeSupported = null;
    private final EventDispatcher<WindowManagerListener> myEventDispatcher = EventDispatcher.create(WindowManagerListener.class);
    private final Rectangle myScreenBounds;
    private final CommandProcessor myCommandProcessor;
    private final WindowWatcher myWindowWatcher;
    private final DesktopLayout myLayout;
    private final HashMap<Project, IdeFrameImpl> myProject2Frame;
    private final HashMap<Project, Set<JDialog>> myDialogsToDispose;
    private Rectangle myFrameBounds;
    private int myFrameExtendedState;
    private final WindowAdapter myActivationListener;
    private final ApplicationInfoEx myApplicationInfoEx;
    private final DataManager myDataManager;
    private final ActionManager myActionManager;
    private final UISettings myUiSettings;
    private final KeymapManager myKeymapManager;

    private static void initialize() {
        try {
            System.loadLibrary("jawt");
            ourAlphaModeLibraryLoaded = true;
        }
        catch (Throwable exc) {
            ourAlphaModeLibraryLoaded = false;
        }
    }

    public WindowManagerImpl(DataManager dataManager, ApplicationInfoEx applicationInfoEx, ActionManager actionManager, UISettings uiSettings, KeymapManager keymapManager) {
        this.myApplicationInfoEx = applicationInfoEx;
        this.myDataManager = dataManager;
        this.myActionManager = actionManager;
        this.myUiSettings = uiSettings;
        this.myKeymapManager = keymapManager;
        if (this.myDataManager instanceof DataManagerImpl) {
            ((DataManagerImpl)this.myDataManager).setWindowManager(this);
        }
        this.myCommandProcessor = new CommandProcessor();
        this.myWindowWatcher = new WindowWatcher();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener(FOCUSED_WINDOW_PROPERTY_NAME, this.myWindowWatcher);
        if (Patches.SUN_BUG_ID_4218084) {
            keyboardFocusManager.addPropertyChangeListener(FOCUSED_WINDOW_PROPERTY_NAME, new SUN_BUG_ID_4218084_Patch());
        }
        this.myLayout = new DesktopLayout();
        this.myProject2Frame = new HashMap();
        this.myDialogsToDispose = new HashMap();
        this.myFrameExtendedState = 0;
        Rectangle screenBounds = new Rectangle();
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            GraphicsDevice[] devices;
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice device : devices = env.getScreenDevices()) {
                screenBounds = screenBounds.union(device.getDefaultConfiguration().getBounds());
            }
        }
        this.myScreenBounds = screenBounds;
        this.myActivationListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                Window activeWindow = e.getWindow();
                if (activeWindow instanceof IdeFrameImpl) {
                    WindowManagerImpl.this.proceedDialogDisposalQueue(((IdeFrameImpl)activeWindow).getProject());
                }
            }
        };
    }

    public void showFrame(String[] args) {
        IdeEventQueue.getInstance().setWindowManager(this);
        IdeFrameImpl frame = new IdeFrameImpl(this.myApplicationInfoEx, this.myActionManager, this.myUiSettings, this.myDataManager, this.myKeymapManager, ApplicationManager.getApplication(), args);
        this.myProject2Frame.put(null, frame);
        if (this.myFrameBounds != null) {
            frame.setBounds(this.myFrameBounds);
        }
        frame.setVisible(true);
        frame.setExtendedState(this.myFrameExtendedState);
    }

    public IdeFrameImpl[] getAllFrames() {
        Collection<IdeFrameImpl> ideFrames = this.myProject2Frame.values();
        return ideFrames.toArray(new IdeFrameImpl[ideFrames.size()]);
    }

    public void addListener(WindowManagerListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(WindowManagerListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    @Override
    public final Rectangle getScreenBounds() {
        return this.myScreenBounds;
    }

    @Override
    public Rectangle getScreenBounds(@NotNull Project project) {
        GraphicsDevice[] devices;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/WindowManagerImpl.getScreenBounds must not be null");
        }
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point onScreen = this.getFrame(project).getLocationOnScreen();
        for (GraphicsDevice device : devices = environment.getScreenDevices()) {
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            if (!bounds.contains(onScreen)) continue;
            return bounds;
        }
        return null;
    }

    public final boolean isInsideScreenBounds(int x, int y, int width) {
        return x >= this.myScreenBounds.x + 50 - width && y >= this.myScreenBounds.y - 50 && x <= this.myScreenBounds.x + this.myScreenBounds.width - 50 && y <= this.myScreenBounds.y + this.myScreenBounds.height - 50;
    }

    public final boolean isInsideScreenBounds(int x, int y) {
        return this.myScreenBounds.contains(x, y);
    }

    @Override
    public final boolean isAlphaModeSupported() {
        if (this.myAlphaModeSupported == null) {
            this.myAlphaModeSupported = WindowManagerImpl.calcAlphaModelSupported();
        }
        return this.myAlphaModeSupported;
    }

    private static boolean calcAlphaModelSupported() {
        if (AWTUtilitiesWrapper.isTranslucencyAPISupported()) {
            return AWTUtilitiesWrapper.isTranslucencySupported(AWTUtilitiesWrapper.TRANSLUCENT);
        }
        try {
            return WindowUtils.isWindowAlphaSupported();
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public final void setAlphaModeRatio(Window window, float ratio) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
        if (ratio < 0.0f || ratio > 1.0f) {
            throw new IllegalArgumentException("ratio must be in [0..1] range. ratio=" + ratio);
        }
        if (!this.isAlphaModeSupported() || !this.isAlphaModeEnabled(window)) {
            return;
        }
        this.setAlphaMode(window, ratio);
    }

    private void setAlphaMode(Window window, float ratio) {
        try {
            if (SystemInfo.isMacOSLeopard) {
                if (window instanceof JWindow) {
                    ((JWindow)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                } else if (window instanceof JDialog) {
                    ((JDialog)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                }
            } else if (AWTUtilitiesWrapper.isTranslucencySupported(AWTUtilitiesWrapper.TRANSLUCENT)) {
                AWTUtilitiesWrapper.setWindowOpacity(window, 1.0f - ratio);
            } else {
                WindowUtils.setWindowAlpha((Window)window, (float)(1.0f - ratio));
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    @Override
    public void setWindowMask(Window window, Shape mask) {
        try {
            if (AWTUtilitiesWrapper.isTranslucencySupported(AWTUtilitiesWrapper.PERPIXEL_TRANSPARENT)) {
                AWTUtilitiesWrapper.setWindowShape(window, mask);
            } else {
                WindowUtils.setWindowMask((Window)window, (Shape)mask);
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    @Override
    public void resetWindow(Window window) {
        try {
            if (!this.isAlphaModeSupported()) {
                return;
            }
            WindowUtils.setWindowMask((Window)window, (Shape)null);
            this.setAlphaMode(window, 0.0f);
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    @Override
    public final boolean isAlphaModeEnabled(Window window) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
        return this.isAlphaModeSupported();
    }

    @Override
    public final void setAlphaModeEnabled(Window window, boolean state) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
    }

    @Override
    public void hideDialog(JDialog dialog, Project project) {
        if (project == null) {
            dialog.dispose();
        } else {
            IdeFrameImpl frame = this.getFrame(project);
            if (frame.isActive()) {
                dialog.dispose();
            } else {
                this.queueForDisposal(dialog, project);
                dialog.setVisible(false);
            }
        }
    }

    public final void disposeComponent() {
    }

    public final void initComponent() {
    }

    public final void doNotSuggestAsParent(Window window) {
        this.myWindowWatcher.doNotSuggestAsParent(window);
    }

    @Override
    public final void dispatchComponentEvent(ComponentEvent e) {
        this.myWindowWatcher.dispatchComponentEvent(e);
    }

    public final Window suggestParentWindow(Project project) {
        return this.myWindowWatcher.suggestParentWindow(project);
    }

    public final StatusBar getStatusBar(Project project) {
        if (!this.myProject2Frame.containsKey(project)) {
            return null;
        }
        IdeFrameImpl frame = this.getFrame(project);
        LOG.assertTrue(frame != null);
        return frame.getStatusBar();
    }

    @Override
    public IdeFrame findFrameFor(@Nullable Project project) {
        IdeFrameImpl frame = null;
        if (project != null) {
            frame = this.getFrame(project);
        } else {
            for (Container eachParent = this.getMostRecentFocusedWindow(); eachParent != null; eachParent = eachParent.getParent()) {
                if (!(eachParent instanceof IdeFrameImpl)) continue;
                frame = (IdeFrameImpl)eachParent;
                break;
            }
            if (frame == null) {
                frame = this.tryToFindTheOnlyFrame();
            }
        }
        LOG.assertTrue(frame != null, (Object)("Project: " + project));
        return frame;
    }

    private IdeFrameImpl tryToFindTheOnlyFrame() {
        Frame[] all;
        IdeFrameImpl candidate = null;
        for (Frame each : all = Frame.getFrames()) {
            if (!(each instanceof IdeFrameImpl)) continue;
            if (candidate == null) {
                candidate = (IdeFrameImpl)each;
                continue;
            }
            candidate = null;
            break;
        }
        return candidate;
    }

    @Override
    public final IdeFrameImpl getFrame(Project project) {
        return this.myProject2Frame.get(project);
    }

    public IdeFrame getIdeFrame(Project project) {
        Frame[] frames;
        if (project != null) {
            return this.getFrame(project);
        }
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Component parent = UIUtil.findUltimateParent((Component)window);
        if (parent instanceof IdeFrame) {
            return (IdeFrame)parent;
        }
        for (Frame each : frames = Frame.getFrames()) {
            if (!(each instanceof IdeFrame)) continue;
            return (IdeFrame)each;
        }
        return null;
    }

    @Override
    public final IdeFrameImpl allocateFrame(Project project) {
        IdeFrameImpl frame;
        LOG.assertTrue(!this.myProject2Frame.containsKey(project));
        if (this.myProject2Frame.containsKey(null)) {
            frame = this.myProject2Frame.get(null);
            this.myProject2Frame.remove(null);
            this.myProject2Frame.put(project, frame);
            frame.setProject(project);
        } else {
            frame = new IdeFrameImpl((ApplicationInfoEx)ApplicationInfo.getInstance(), ActionManager.getInstance(), UISettings.getInstance(), DataManager.getInstance(), KeymapManager.getInstance(), ApplicationManager.getApplication(), ArrayUtil.EMPTY_STRING_ARRAY);
            if (this.myFrameBounds != null) {
                frame.setBounds(this.myFrameBounds);
            }
            frame.setProject(project);
            this.myProject2Frame.put(project, frame);
            frame.setVisible(true);
        }
        frame.addWindowListener(this.myActivationListener);
        ((WindowManagerListener)this.myEventDispatcher.getMulticaster()).frameCreated((IdeFrame)frame);
        return frame;
    }

    private void proceedDialogDisposalQueue(Project project) {
        Set<JDialog> dialogs = this.myDialogsToDispose.get(project);
        if (dialogs == null) {
            return;
        }
        for (JDialog dialog : dialogs) {
            dialog.dispose();
        }
        this.myDialogsToDispose.put(project, null);
    }

    private void queueForDisposal(JDialog dialog, Project project) {
        Set<JDialog> dialogs = this.myDialogsToDispose.get(project);
        if (dialogs == null) {
            dialogs = new HashSet<JDialog>();
            this.myDialogsToDispose.put(project, dialogs);
        }
        dialogs.add(dialog);
    }

    @Override
    public final void releaseFrame(IdeFrameImpl frame) {
        ((WindowManagerListener)this.myEventDispatcher.getMulticaster()).beforeFrameReleased((IdeFrame)frame);
        Project project = frame.getProject();
        LOG.assertTrue(project != null);
        frame.removeWindowListener(this.myActivationListener);
        this.proceedDialogDisposalQueue(project);
        frame.setProject(null);
        frame.setTitle(null);
        frame.setFileTitle(null, null);
        StatusBarEx statusBar = frame.getStatusBar();
        statusBar.clear();
        this.myProject2Frame.remove(project);
        if (this.myProject2Frame.isEmpty()) {
            this.myProject2Frame.put(null, frame);
        } else {
            statusBar.dispose();
            frame.dispose();
        }
    }

    @Override
    public final Window getMostRecentFocusedWindow() {
        return this.myWindowWatcher.getFocusedWindow();
    }

    @Override
    public final Component getFocusedComponent(@NotNull Window window) {
        if (window == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/WindowManagerImpl.getFocusedComponent must not be null");
        }
        return this.myWindowWatcher.getFocusedComponent(window);
    }

    @Override
    public final Component getFocusedComponent(Project project) {
        return this.myWindowWatcher.getFocusedComponent(project);
    }

    @Override
    public final CommandProcessor getCommandProcessor() {
        return this.myCommandProcessor;
    }

    public final String getExternalFileName() {
        return "window.manager";
    }

    public final void readExternal(Element element) {
        Element desktopElement;
        Element frameElement = element.getChild(FRAME_ELEMENT);
        if (frameElement != null) {
            this.myFrameBounds = WindowManagerImpl.loadFrameBounds(frameElement);
            try {
                this.myFrameExtendedState = Integer.parseInt(frameElement.getAttributeValue(EXTENDED_STATE_ATTR));
                if ((this.myFrameExtendedState & 1) > 0) {
                    this.myFrameExtendedState = 0;
                }
            }
            catch (NumberFormatException ignored) {
                this.myFrameExtendedState = 0;
            }
        }
        if ((desktopElement = element.getChild("layout")) != null) {
            this.myLayout.readExternal(desktopElement);
        }
    }

    private static Rectangle loadFrameBounds(Element frameElement) {
        Rectangle bounds = new Rectangle();
        try {
            bounds.x = Integer.parseInt(frameElement.getAttributeValue(X_ATTR));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        try {
            bounds.y = Integer.parseInt(frameElement.getAttributeValue(Y_ATTR));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        try {
            bounds.width = Integer.parseInt(frameElement.getAttributeValue(WIDTH_ATTR));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        try {
            bounds.height = Integer.parseInt(frameElement.getAttributeValue(HEIGHT_ATTR));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        return bounds;
    }

    public final void writeExternal(Element element) {
        Element frameElement = new Element(FRAME_ELEMENT);
        element.addContent(frameElement);
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        Project project = projects.length > 0 ? projects[projects.length - 1] : null;
        IdeFrameImpl frame = this.getFrame(project);
        if (frame != null) {
            Rectangle rectangle = frame.getBounds();
            frameElement.setAttribute(X_ATTR, Integer.toString(rectangle.x));
            frameElement.setAttribute(Y_ATTR, Integer.toString(rectangle.y));
            frameElement.setAttribute(WIDTH_ATTR, Integer.toString(rectangle.width));
            frameElement.setAttribute(HEIGHT_ATTR, Integer.toString(rectangle.height));
            frameElement.setAttribute(EXTENDED_STATE_ATTR, Integer.toString(frame.getExtendedState()));
            Element layoutElement = new Element("layout");
            element.addContent(layoutElement);
            this.myLayout.writeExternal(layoutElement);
        }
    }

    @Override
    public final DesktopLayout getLayout() {
        return this.myLayout;
    }

    @Override
    public final void setLayout(DesktopLayout layout) {
        this.myLayout.copyFrom(layout);
    }

    @NotNull
    public final String getComponentName() {
        if ("WindowManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/wm/impl/WindowManagerImpl.getComponentName must not return null");
        }
        return "WindowManager";
    }

    public WindowWatcher getWindowWatcher() {
        return this.myWindowWatcher;
    }

    static {
        WindowManagerImpl.initialize();
    }

    private static final class SUN_BUG_ID_4218084_Patch
    implements PropertyChangeListener {
        private final Alarm myAlarm = new Alarm();
        private Window myInitialFocusedWindow;
        private Window myLastFocusedWindow;
        private final Runnable myClearSelectedPathRunnable = new Runnable(){

            @Override
            public void run() {
                if (SUN_BUG_ID_4218084_Patch.this.myInitialFocusedWindow != SUN_BUG_ID_4218084_Patch.this.myLastFocusedWindow) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            }
        };

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (this.myAlarm.getActiveRequestCount() == 0) {
                this.myInitialFocusedWindow = (Window)e.getOldValue();
                MenuElement[] selectedPath = MenuSelectionManager.defaultManager().getSelectedPath();
                if (selectedPath.length == 0) {
                    return;
                }
                Component firstComponent = null;
                for (MenuElement menuElement : selectedPath) {
                    Component component = menuElement.getComponent();
                    if (component instanceof JMenuBar) {
                        firstComponent = component;
                        break;
                    }
                    if (!(component instanceof JPopupMenu)) continue;
                    firstComponent = ((JPopupMenu)component).getInvoker();
                    break;
                }
                if (firstComponent == null) {
                    return;
                }
                Window window = SwingUtilities.getWindowAncestor(firstComponent);
                if (window != this.myInitialFocusedWindow) {
                    return;
                }
            }
            this.myLastFocusedWindow = (Window)e.getNewValue();
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(this.myClearSelectedPathRunnable, 150);
        }
    }
}

