/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.platform.ProjectBaseDirectory;

public class PlatformFrameTitleBuilder
extends FrameTitleBuilder {
    @Override
    public String getProjectTitle(Project project) {
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null) {
            return project.getName() + " - [" + baseDir.getPresentableUrl() + "]";
        }
        return project.getName();
    }

    @Override
    public String getFileTitle(Project project, VirtualFile file) {
        String projectHomeUrl;
        String url = file.getPresentableUrl();
        VirtualFile baseDir = ProjectBaseDirectory.getInstance(project).getBaseDir();
        if (baseDir == null) {
            baseDir = project.getBaseDir();
        }
        if (baseDir != null && url.startsWith(projectHomeUrl = baseDir.getPresentableUrl())) {
            url = "..." + url.substring(projectHomeUrl.length());
        }
        return url;
    }
}

