/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.win32.Win32LocalFileSystem;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.containers.Queue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class RefreshWorker {
    private final VirtualFile myRefreshRoot;
    private final boolean myIsRecursive;
    private final Queue<VirtualFile> myRefreshQueue = new Queue(100);
    private final List<VFileEvent> myEvents = new ArrayList<VFileEvent>();

    public RefreshWorker(VirtualFile refreshRoot, boolean isRecursive) {
        this.myRefreshRoot = refreshRoot;
        this.myIsRecursive = isRecursive;
        this.myRefreshQueue.addLast((Object)refreshRoot);
    }

    public void scan() {
        NewVirtualFile root = (NewVirtualFile)this.myRefreshRoot;
        Object delegate = root.getFileSystem();
        if (root.isDirty() && !delegate.exists((VirtualFile)root)) {
            this.scheduleDeletion((VirtualFile)root);
            root.markClean();
        } else {
            if (delegate.getProtocol().equals("file") && root.isDirectory() && Registry.is((String)"filesystem.useNative") && SystemInfo.isWindows && Win32LocalFileSystem.isAvailable()) {
                delegate = Win32LocalFileSystem.getWin32Instance();
            }
            PersistentFS persistence = (PersistentFS)ManagingFS.getInstance();
            while (!this.myRefreshQueue.isEmpty()) {
                boolean uptodateWritable;
                boolean currentWritable;
                VirtualFileSystemEntry file = (VirtualFileSystemEntry)((Object)this.myRefreshQueue.pullFirst());
                if (!file.isDirty()) continue;
                if (file.isDirectory()) {
                    VirtualDirectoryImpl dir = (VirtualDirectoryImpl)file;
                    boolean fullSync = dir.allChildrenLoaded();
                    if (fullSync) {
                        HashSet<String> currentNames = new HashSet<String>(Arrays.asList(persistence.list((VirtualFile)file)));
                        HashSet<String> uptodateNames = new HashSet<String>(Arrays.asList(VfsUtil.filterNames((String[])delegate.list((VirtualFile)file))));
                        HashSet<String> newNames = new HashSet<String>(uptodateNames);
                        newNames.removeAll(currentNames);
                        HashSet<String> deletedNames = new HashSet<String>(currentNames);
                        deletedNames.removeAll(uptodateNames);
                        for (String name : deletedNames) {
                            this.scheduleDeletion((VirtualFile)file.findChild(name));
                        }
                        for (String name : newNames) {
                            boolean isDirectory = delegate.isDirectory((VirtualFile)new FakeVirtualFile((VirtualFile)file, name));
                            this.scheduleCreation(file, name, isDirectory);
                        }
                        for (VirtualFile child : file.getChildren()) {
                            if (deletedNames.contains(child.getName())) continue;
                            this.scheduleChildRefresh(file, child, (NewVirtualFileSystem)delegate);
                        }
                    } else {
                        for (VirtualFile child : file.getCachedChildren()) {
                            if (delegate.exists(child)) {
                                this.scheduleChildRefresh(file, child, (NewVirtualFileSystem)delegate);
                                continue;
                            }
                            this.scheduleDeletion(child);
                        }
                        List<String> names = dir.getSuspicousNames();
                        for (String name : names) {
                            FakeVirtualFile fake;
                            if (name.length() == 0 || !delegate.exists((VirtualFile)(fake = new FakeVirtualFile((VirtualFile)file, name)))) continue;
                            this.scheduleCreation(file, name, delegate.isDirectory((VirtualFile)fake));
                        }
                    }
                } else {
                    long updtodateTimestamp;
                    long currentTimestamp = persistence.getTimeStamp((VirtualFile)file);
                    if (currentTimestamp != (updtodateTimestamp = delegate.getTimeStamp((VirtualFile)file))) {
                        this.scheduleUpdateContent(file);
                    }
                }
                if ((currentWritable = persistence.isWritable((VirtualFile)file)) != (uptodateWritable = delegate.isWritable((VirtualFile)file))) {
                    this.scheduleWritableAttributeChange(file, currentWritable, uptodateWritable);
                }
                file.markClean();
            }
        }
    }

    private void scheduleChildRefresh(VirtualFileSystemEntry file, VirtualFile child, NewVirtualFileSystem delegate) {
        boolean uptodateisDirectory;
        boolean currentIsDirectory = child.isDirectory();
        if (currentIsDirectory != (uptodateisDirectory = delegate.isDirectory(child))) {
            this.scheduleDeletion(child);
            this.scheduleCreation(file, child.getName(), uptodateisDirectory);
        } else if (this.myIsRecursive || !currentIsDirectory) {
            this.myRefreshQueue.addLast((Object)child);
        }
    }

    private void scheduleWritableAttributeChange(VirtualFileSystemEntry file, boolean currentWritable, boolean uptodateWritable) {
        this.myEvents.add((VFileEvent)new VFilePropertyChangeEvent(null, (VirtualFile)file, "writable", (Object)currentWritable, (Object)uptodateWritable, true));
    }

    private void scheduleUpdateContent(VirtualFileSystemEntry file) {
        this.myEvents.add((VFileEvent)new VFileContentChangeEvent(null, (VirtualFile)file, file.getModificationStamp(), -1L, true));
    }

    private void scheduleCreation(VirtualFileSystemEntry parent, String childName, boolean isDirectory) {
        this.myEvents.add((VFileEvent)new VFileCreateEvent(null, (VirtualFile)parent, childName, isDirectory, true));
    }

    private void scheduleDeletion(VirtualFile file) {
        if (file == null) {
            return;
        }
        this.myEvents.add((VFileEvent)new VFileDeleteEvent(null, file, true));
    }

    public List<VFileEvent> getEvents() {
        return this.myEvents;
    }
}

