/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class VirtualFileSystemEntry
extends NewVirtualFile {
    protected static final PersistentFS ourPersistence = (PersistentFS)ManagingFS.getInstance();
    private static final byte DIRTY_FLAG = 1;
    private volatile String myName;
    private volatile VirtualDirectoryImpl myParent;
    private volatile byte myFlags = 0;
    private volatile int myId;

    public VirtualFileSystemEntry(String name, VirtualDirectoryImpl parent, int id) {
        this.myName = name.replace('\\', '/');
        this.myParent = parent;
        this.myId = id;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getName() {
        String string;
        if (this.myParent == null && this.getFileSystem() instanceof JarFileSystem) {
            String jarName = this.myName.substring(0, this.myName.length() - "!/".length());
            string = jarName.substring(jarName.lastIndexOf(47) + 1);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry.getName must not return null");
            return string;
        }
        string = this.myName;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry.getName must not return null");
    }

    public VirtualFileSystemEntry getParent() {
        return this.myParent;
    }

    protected void appendPathOnFileSystem(StringBuilder builder, boolean includeFSBaseUrl) {
        if (this.myParent != null) {
            this.myParent.appendPathOnFileSystem(builder, includeFSBaseUrl);
        } else if (includeFSBaseUrl) {
            builder.append(this.getFileSystem().getProtocol()).append("://");
        }
        if (this.myName.length() > 0) {
            int len = builder.length();
            if (len > 0 && builder.charAt(len - 1) != '/') {
                builder.append('/');
            }
            builder.append(this.myName);
        }
    }

    public boolean isDirty() {
        return (this.myFlags & 1) != 0;
    }

    public void setFlag(int flag_mask, boolean value) {
        this.myFlags = value ? (byte)(this.myFlags | flag_mask) : (byte)(this.myFlags & ~flag_mask);
    }

    public boolean getFlag(int flag_mask) {
        return (this.myFlags & flag_mask) != 0;
    }

    public void markClean() {
        this.setFlag(1, false);
    }

    public void markDirty() {
        if (!this.isDirty()) {
            this.setFlag(1, true);
            if (this.myParent != null) {
                this.myParent.markDirty();
            }
        }
    }

    public void markDirtyRecursively() {
        this.markDirty();
        for (VirtualFile file : this.getCachedChildren()) {
            ((NewVirtualFile)file).markDirtyRecursively();
        }
    }

    @NotNull
    public String getUrl() {
        StringBuilder builder = new StringBuilder();
        this.appendPathOnFileSystem(builder, true);
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry.getUrl must not return null");
        }
        return string;
    }

    @NotNull
    public String getPath() {
        StringBuilder builder = new StringBuilder();
        this.appendPathOnFileSystem(builder, false);
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry.getPath must not return null");
        }
        return string;
    }

    public void delete(Object requestor) throws IOException {
        ourPersistence.deleteFile(requestor, (VirtualFile)this);
    }

    public void rename(Object requestor, @NotNull @NonNls String newName) throws IOException {
        if (newName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry.rename must not be null");
        }
        if (this.getName().equals(newName)) {
            return;
        }
        if (!VfsUtil.isValidName((String)newName)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{newName}));
        }
        ourPersistence.renameFile(requestor, (VirtualFile)this, newName);
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry.createChildData must not be null");
        }
        VirtualFileSystemEntry.validateName(name);
        VirtualFile virtualFile = ourPersistence.createChildFile(requestor, (VirtualFile)this, name);
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry.createChildData must not return null");
        }
        return virtualFile;
    }

    public boolean isWritable() {
        return ourPersistence.isWritable((VirtualFile)this);
    }

    public void setWritable(boolean writable) throws IOException {
        ourPersistence.setWritable((VirtualFile)this, writable);
    }

    public long getTimeStamp() {
        return ourPersistence.getTimeStamp((VirtualFile)this);
    }

    public void setTimeStamp(long time) throws IOException {
        ourPersistence.setTimeStamp((VirtualFile)this, time);
    }

    public long getLength() {
        return ourPersistence.getLength((VirtualFile)this);
    }

    public VirtualFile copy(final Object requestor, final VirtualFile newParent, final String copyName) throws IOException {
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message((String)"file.copy.error", (Object[])new Object[]{newParent.getPresentableUrl()}));
        }
        if (!newParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"file.copy.target.must.be.directory", (Object[])new Object[0]));
        }
        return VfsUtil.doActionAndRestoreEncoding((VirtualFile)this, (ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                return ourPersistence.copyFile(requestor, (VirtualFile)VirtualFileSystemEntry.this, newParent, copyName);
            }
        });
    }

    public void move(final Object requestor, final VirtualFile newParent) throws IOException {
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message((String)"file.move.error", (Object[])new Object[]{newParent.getPresentableUrl()}));
        }
        VfsUtil.doActionAndRestoreEncoding((VirtualFile)this, (ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                ourPersistence.moveFile(requestor, (VirtualFile)VirtualFileSystemEntry.this, newParent);
                return VirtualFileSystemEntry.this;
            }
        });
    }

    public int getId() {
        return this.myId;
    }

    public int hashCode() {
        return this.myId >= 0 ? this.myId : -this.myId;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, String name) throws IOException {
        VirtualFileSystemEntry.validateName(name);
        VirtualFile virtualFile = ourPersistence.createChildDirectory(requestor, (VirtualFile)this, name);
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry.createChildDirectory must not return null");
        }
        return virtualFile;
    }

    private static void validateName(String name) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IOException("File name cannot be empty");
        }
        if (name.indexOf(47) >= 0 || name.indexOf(File.separatorChar) >= 0) {
            throw new IOException("File name cannot contain file path separators: '" + name + "'");
        }
    }

    public boolean exists() {
        return ourPersistence.exists((VirtualFile)this);
    }

    public boolean isValid() {
        return this.exists();
    }

    public String toString() {
        return this.getUrl();
    }

    public void setName(String newName) {
        if (newName != null && newName.length() == 0) {
            throw new IllegalArgumentException("Name of the virtual file cannot be set to empty string");
        }
        this.myParent.removeChild((VirtualFile)this);
        this.myName = newName != null ? newName.replace('\\', '/') : null;
        this.myParent.addChild((VirtualFile)this);
    }

    public void setParent(VirtualFile newParent) {
        this.myParent.removeChild((VirtualFile)this);
        this.myParent = (VirtualDirectoryImpl)newParent;
        this.myParent.addChild((VirtualFile)this);
    }

    public boolean isInLocalFileSystem() {
        return this.getFileSystem() instanceof LocalFileSystem;
    }

    public void invalidate() {
        this.myId = -Math.abs(this.myId);
    }

    public Charset getCharset() {
        Charset charset;
        if (this.isCharsetSet()) {
            charset = super.getCharset();
        } else {
            if (this.isDirectory()) {
                Charset configured = EncodingManager.getInstance().getEncoding((VirtualFile)this, true);
                charset = configured == null ? Charset.defaultCharset() : configured;
            } else {
                try {
                    byte[] content;
                    try {
                        content = this.contentsToByteArray();
                    }
                    catch (FileNotFoundException e) {
                        return super.getCharset();
                    }
                    charset = LoadTextUtil.detectCharset((VirtualFile)this, content);
                }
                catch (FileTooBigException e) {
                    return super.getCharset();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.setCharset(charset);
        }
        return charset;
    }

    public String getPresentableName() {
        if (UISettings.getInstance().HIDE_KNOWN_EXTENSION_IN_TABS && !this.isDirectory()) {
            String nameWithoutExtension = this.getNameWithoutExtension();
            return nameWithoutExtension.length() == 0 ? this.getName() : nameWithoutExtension;
        }
        return this.getName();
    }
}

