/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFilePointerContainerImpl
implements VirtualFilePointerContainer,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer");
    @NotNull
    private final List<VirtualFilePointer> myList;
    private final List<VirtualFilePointer> myReadOnlyList;
    private final VirtualFilePointerManagerImpl myVirtualFilePointerManager;
    private final Disposable myParent;
    private final VirtualFilePointerListener myListener;
    private VirtualFile[] myCachedDirectories;
    @NonNls
    private static final String URL_ATTR = "url";
    private boolean myDisposed;
    private String[] myCachedUrls;
    private VirtualFile[] myCachedFiles;

    public VirtualFilePointerContainerImpl(@NotNull VirtualFilePointerManagerImpl manager, @NotNull Disposable parent, VirtualFilePointerListener listener) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.<init> must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.<init> must not be null");
        }
        this.myList = new ArrayList<VirtualFilePointer>();
        this.myReadOnlyList = Collections.unmodifiableList(this.myList);
        this.myVirtualFilePointerManager = manager;
        this.myParent = parent;
        this.myListener = listener;
    }

    public void readExternal(@NotNull Element rootChild, @NotNull String childElements) throws InvalidDataException {
        if (rootChild == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.readExternal must not be null");
        }
        if (childElements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.readExternal must not be null");
        }
        List urls = rootChild.getChildren(childElements);
        for (Object url : urls) {
            Element pathElement = (Element)url;
            String urlAttribute = pathElement.getAttributeValue(URL_ATTR);
            if (urlAttribute == null) {
                throw new InvalidDataException("path element without url");
            }
            this.add(urlAttribute);
        }
    }

    public void writeExternal(@NotNull Element element, @NotNull String childElementName) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.writeExternal must not be null");
        }
        if (childElementName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.writeExternal must not be null");
        }
        for (int i = 0; i < this.getList().size(); ++i) {
            String url = this.getList().get(i).getUrl();
            Element rootPathElement = new Element(childElementName);
            rootPathElement.setAttribute(URL_ATTR, url);
            element.addContent(rootPathElement);
        }
    }

    public void moveUp(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.moveUp must not be null");
        }
        int index = this.indexOf(url);
        if (index <= 0) {
            return;
        }
        this.dropCaches();
        ContainerUtil.swapElements(this.myList, (int)(index - 1), (int)index);
    }

    public void moveDown(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.moveDown must not be null");
        }
        int index = this.indexOf(url);
        if (index < 0 || index + 1 >= this.myList.size()) {
            return;
        }
        this.dropCaches();
        ContainerUtil.swapElements(this.myList, (int)index, (int)(index + 1));
    }

    private int indexOf(String url) {
        for (int i = 0; i < this.myList.size(); ++i) {
            VirtualFilePointer pointer = this.myList.get(i);
            if (!url.equals(pointer.getUrl())) continue;
            return i;
        }
        return -1;
    }

    public void killAll() {
        this.myList.clear();
    }

    public void add(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.add must not be null");
        }
        assert (!this.myDisposed);
        this.dropCaches();
        VirtualFilePointer pointer = this.create(file);
        this.myList.add(pointer);
    }

    public void add(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.add must not be null");
        }
        assert (!this.myDisposed);
        this.dropCaches();
        VirtualFilePointer pointer = this.create(url);
        this.myList.add(pointer);
    }

    public void remove(@NotNull VirtualFilePointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.remove must not be null");
        }
        assert (!this.myDisposed);
        this.dropCaches();
        boolean result = this.myList.remove(pointer);
        LOG.assertTrue(result);
    }

    @NotNull
    public List<VirtualFilePointer> getList() {
        assert (!this.myDisposed);
        List<VirtualFilePointer> list = this.myReadOnlyList;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.getList must not return null");
        }
        return list;
    }

    public void addAll(@NotNull VirtualFilePointerContainer that) {
        if (that == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.addAll must not be null");
        }
        assert (!this.myDisposed);
        this.dropCaches();
        List<VirtualFilePointer> thatList = ((VirtualFilePointerContainerImpl)that).myList;
        for (VirtualFilePointer pointer : thatList) {
            this.myList.add(this.duplicate(pointer));
        }
    }

    void dropCaches() {
        this.myCachedDirectories = null;
        this.myCachedFiles = null;
        this.myCachedUrls = null;
    }

    @NotNull
    public String[] getUrls() {
        assert (!this.myDisposed);
        if (this.myCachedUrls == null) {
            this.myCachedUrls = this.calcUrls();
        }
        if (this.myCachedUrls == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.getUrls must not return null");
        }
        return this.myCachedUrls;
    }

    private String[] calcUrls() {
        if (this.myList.isEmpty()) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>(this.myList.size());
        for (VirtualFilePointer smartVirtualFilePointer : this.myList) {
            result.add(smartVirtualFilePointer.getUrl());
        }
        return ArrayUtil.toStringArray(result);
    }

    @NotNull
    public VirtualFile[] getFiles() {
        assert (!this.myDisposed);
        if (this.myCachedFiles == null) {
            this.myCachedFiles = this.calcFiles();
        }
        if (this.myCachedFiles == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.getFiles must not return null");
        }
        return this.myCachedFiles;
    }

    private VirtualFile[] calcFiles() {
        if (this.myList.isEmpty()) {
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(this.myList.size());
        for (VirtualFilePointer pointer : this.myList) {
            VirtualFile file = pointer.getFile();
            if (file == null) continue;
            result.add(file);
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    @NotNull
    public VirtualFile[] getDirectories() {
        assert (!this.myDisposed);
        if (this.myCachedDirectories == null) {
            this.myCachedDirectories = this.calcDirectories();
        }
        if (this.myCachedDirectories == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.getDirectories must not return null");
        }
        return this.myCachedDirectories;
    }

    private VirtualFile[] calcDirectories() {
        if (this.myList.isEmpty()) {
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(this.myList.size());
        for (VirtualFilePointer smartVirtualFilePointer : this.myList) {
            VirtualFile file = smartVirtualFilePointer.getFile();
            if (file == null || !file.isDirectory()) continue;
            LOG.assertTrue(file.isValid());
            result.add(file);
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    @Nullable
    public VirtualFilePointer findByUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.findByUrl must not be null");
        }
        assert (!this.myDisposed);
        for (VirtualFilePointer pointer : this.myList) {
            if (!pointer.getUrl().equals(url)) continue;
            return pointer;
        }
        return null;
    }

    public void clear() {
        this.dropCaches();
        this.killAll();
    }

    public int size() {
        return this.myList.size();
    }

    public Object get(int index) {
        return this.myList.get(index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualFilePointerContainerImpl)) {
            return false;
        }
        VirtualFilePointerContainerImpl virtualFilePointerContainer = (VirtualFilePointerContainerImpl)o;
        return ((Object)this.myList).equals(virtualFilePointerContainer.myList);
    }

    public int hashCode() {
        return ((Object)this.myList).hashCode();
    }

    protected VirtualFilePointer create(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.create must not be null");
        }
        return this.myVirtualFilePointerManager.create(file, this.myParent, this.myListener);
    }

    protected VirtualFilePointer create(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.create must not be null");
        }
        return this.myVirtualFilePointerManager.create(url, this.myParent, this.myListener);
    }

    protected VirtualFilePointer duplicate(@NotNull VirtualFilePointer virtualFilePointer) {
        if (virtualFilePointer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.duplicate must not be null");
        }
        return this.myVirtualFilePointerManager.duplicate(virtualFilePointer, this.myParent, this.myListener);
    }

    public String toString() {
        return "VFPContainer: " + this.myList;
    }

    @NotNull
    public VirtualFilePointerContainer clone(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.clone must not be null");
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.clone(parent, null);
        if (virtualFilePointerContainer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.clone must not return null");
        }
        return virtualFilePointerContainer;
    }

    @NotNull
    public VirtualFilePointerContainer clone(@NotNull Disposable parent, VirtualFilePointerListener listener) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.clone must not be null");
        }
        assert (!this.myDisposed);
        VirtualFilePointerContainer clone = this.myVirtualFilePointerManager.createContainer(parent, listener);
        for (VirtualFilePointer pointer : this.myList) {
            clone.add(pointer.getUrl());
        }
        VirtualFilePointerContainer virtualFilePointerContainer = clone;
        if (virtualFilePointerContainer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl.clone must not return null");
        }
        return virtualFilePointerContainer;
    }

    public void dispose() {
        assert (!this.myDisposed);
        this.myDisposed = true;
    }
}

