/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.FilesForRefresh;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.concurrency.Semaphore;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class RefreshVFsSynchronously {
    private RefreshVFsSynchronously() {
    }

    public static void updateAllChanged(final UpdatedFiles updatedFiles) {
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(false);
        }
        final int num = RefreshVFsSynchronously.getFilesNum(updatedFiles);
        RefreshVFsSynchronously.wrapIntoLock(new Runnable(){

            @Override
            public void run() {
                UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(updatedFiles, new MyRefreshCallback(num, progressIndicator));
            }
        });
    }

    private static int getFilesNum(UpdatedFiles files) {
        int result = 0;
        for (FileGroup group : files.getTopLevelGroups()) {
            result += group.getImmediateFilesSize();
            List children = group.getChildren();
            for (FileGroup child : children) {
                result += child.getImmediateFilesSize();
            }
        }
        return result;
    }

    @Nullable
    public static VirtualFile findCreatedFile(File root) {
        RefreshVFsSynchronously.refresh(root);
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        return lfs.findFileByIoFile(root);
    }

    private static void refresh(File root) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile vFile = lfs.refreshAndFindFileByIoFile(root);
        if (vFile != null) {
            vFile.refresh(false, false);
            return;
        }
    }

    private static void refreshDeletedOrReplaced(File root) {
        File parent = root.getParentFile();
        VirtualFile vf = null;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile rootVf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(root);
        if (parent != null) {
            vf = localFileSystem.refreshAndFindFileByIoFile(parent);
        }
        if (vf == null) {
            vf = rootVf;
        }
        if (vf != null) {
            ((NewVirtualFile)vf).markDirtyRecursively();
            vf.refresh(false, true);
        }
    }

    public static void updateChangesForRollback(List<Change> changes) {
        RefreshVFsSynchronously.updateChangesImpl(changes, RollbackChangeWrapper.ourInstance);
    }

    public static void updateChanges(List<Change> changes) {
        RefreshVFsSynchronously.updateChangesImpl(changes, DirectChangeWrapper.ourInstance);
    }

    private static void updateChangesImpl(List<Change> changes, ChangeWrapper wrapper) {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.setIndeterminate(false);
        }
        double num = changes.size();
        int cnt = 0;
        FilesForRefresh filesForRefresh = new FilesForRefresh();
        for (Change change : changes) {
            if (!wrapper.beforeNull(change) && (wrapper.movedOrRenamedOrReplaced(change) || wrapper.afterNull(change))) {
                RefreshVFsSynchronously.refreshDeletedOrReplaced(wrapper.getBeforeFile(change));
            } else if (!wrapper.beforeNull(change)) {
                RefreshVFsSynchronously.refresh(wrapper.getBeforeFile(change));
            }
            if (!wrapper.afterNull(change) && !Comparing.equal((Object)change.getAfterRevision(), (Object)change.getBeforeRevision())) {
                RefreshVFsSynchronously.refreshDeletedOrReplaced(wrapper.getAfterFile(change));
            }
            if (pi == null) continue;
            pi.setFraction((double)(++cnt) / num);
            pi.setText2("Refreshing: " + change.toString());
        }
    }

    private static void wrapIntoLock(final Runnable runnable) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.startNonCancelableSection();
            indicator.setText(VcsBundle.message((String)"progress.text.synchronizing.files", (Object[])new Object[0]));
            indicator.setText2("");
        }
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    semaphore.up();
                }
            }
        });
        semaphore.waitFor();
    }

    private static class MyRefreshCallback
    implements UpdateFilesHelper.Callback {
        private int myCnt;
        private final double myTotal;
        private final ProgressIndicator myProgressIndicator;

        private MyRefreshCallback(int total, ProgressIndicator progressIndicator) {
            this.myTotal = total;
            this.myProgressIndicator = progressIndicator;
            this.myCnt = 0;
        }

        @Override
        public void onFile(String filePath, String groupId) {
            File file = new File(filePath);
            if ("REMOVED_FROM_REPOSITORY".equals(groupId)) {
                RefreshVFsSynchronously.refreshDeletedOrReplaced(file);
            } else {
                RefreshVFsSynchronously.refresh(file);
            }
            if (this.myProgressIndicator != null) {
                ++this.myCnt;
                this.myProgressIndicator.setFraction((double)this.myCnt / this.myTotal);
                this.myProgressIndicator.setText2("Refreshing " + filePath);
            }
        }
    }

    private static interface ChangeWrapper {
        public boolean beforeNull(Change var1);

        public boolean afterNull(Change var1);

        @Nullable
        public File getBeforeFile(Change var1);

        @Nullable
        public File getAfterFile(Change var1);

        public boolean movedOrRenamedOrReplaced(Change var1);
    }

    private static class DirectChangeWrapper
    implements ChangeWrapper {
        private static final DirectChangeWrapper ourInstance = new DirectChangeWrapper();

        private DirectChangeWrapper() {
        }

        @Override
        public boolean beforeNull(Change change) {
            return change.getBeforeRevision() == null;
        }

        @Override
        public boolean afterNull(Change change) {
            return change.getAfterRevision() == null;
        }

        @Override
        @Nullable
        public File getBeforeFile(Change change) {
            return this.beforeNull(change) ? null : change.getBeforeRevision().getFile().getIOFile();
        }

        @Override
        @Nullable
        public File getAfterFile(Change change) {
            return this.afterNull(change) ? null : change.getAfterRevision().getFile().getIOFile();
        }

        @Override
        public boolean movedOrRenamedOrReplaced(Change change) {
            return change.isIsReplaced() || change.isRenamed() || change.isIsReplaced();
        }
    }

    private static class RollbackChangeWrapper
    implements ChangeWrapper {
        private static final RollbackChangeWrapper ourInstance = new RollbackChangeWrapper();

        private RollbackChangeWrapper() {
        }

        @Override
        public boolean beforeNull(Change change) {
            return change.getAfterRevision() == null;
        }

        @Override
        public boolean afterNull(Change change) {
            return change.getBeforeRevision() == null;
        }

        @Override
        public File getBeforeFile(Change change) {
            return this.beforeNull(change) ? null : change.getAfterRevision().getFile().getIOFile();
        }

        @Override
        public File getAfterFile(Change change) {
            return this.afterNull(change) ? null : change.getBeforeRevision().getFile().getIOFile();
        }

        @Override
        public boolean movedOrRenamedOrReplaced(Change change) {
            return change.isIsReplaced() || change.isRenamed() || change.isIsReplaced();
        }
    }
}

