/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowConfirmationOptionImpl;
import com.intellij.openapi.vcs.VcsShowOptionsSettingImpl;
import com.intellij.openapi.vcs.impl.projectlevelman.OptionsAndConfirmations;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ProjectLevelVcsManagerSerialization {
    @NonNls
    private static final String OPTIONS_SETTING = "OptionsSetting";
    @NonNls
    private static final String CONFIRMATIONS_SETTING = "ConfirmationsSetting";
    @NonNls
    private static final String VALUE_ATTTIBUTE = "value";
    @NonNls
    private static final String ID_ATTRIBUTE = "id";
    @NonNls
    private static final String ELEMENT_MAPPING = "mapping";
    @NonNls
    private static final String ATTRIBUTE_DIRECTORY = "directory";
    @NonNls
    private static final String ATTRIBUTE_VCS = "vcs";
    @NonNls
    private static final String ATTRIBUTE_DEFAULT_PROJECT = "defaultProject";
    @NonNls
    private static final String ELEMENT_ROOT_SETTINGS = "rootSettings";
    @NonNls
    private static final String ATTRIBUTE_CLASS = "class";
    private final Map<String, VcsShowConfirmationOption.Value> myReadValue = new HashMap();

    private VcsShowOptionsSettingImpl getOrCreateOption(Map<String, VcsShowOptionsSettingImpl> options, String actionName) {
        if (!options.containsKey(actionName)) {
            options.put(actionName, new VcsShowOptionsSettingImpl(actionName));
        }
        return options.get(actionName);
    }

    public void readExternalUtil(Element element, OptionsAndConfirmations optionsAndConfirmations) throws InvalidDataException {
        String value;
        String id;
        Element subElement;
        Map<String, VcsShowOptionsSettingImpl> options = optionsAndConfirmations.getOptions();
        List subElements = element.getChildren(OPTIONS_SETTING);
        for (Object o : subElements) {
            if (!(o instanceof Element)) continue;
            subElement = (Element)o;
            id = subElement.getAttributeValue(ID_ATTRIBUTE);
            value = subElement.getAttributeValue(VALUE_ATTTIBUTE);
            if (id == null || value == null) continue;
            try {
                boolean booleanValue = Boolean.valueOf(value);
                this.getOrCreateOption(options, id).setValue(booleanValue);
            }
            catch (Exception e) {}
        }
        this.myReadValue.clear();
        subElements = element.getChildren(CONFIRMATIONS_SETTING);
        for (Object o : subElements) {
            if (!(o instanceof Element)) continue;
            subElement = (Element)o;
            id = subElement.getAttributeValue(ID_ATTRIBUTE);
            value = subElement.getAttributeValue(VALUE_ATTTIBUTE);
            if (id == null || value == null) continue;
            try {
                this.myReadValue.put(id, VcsShowConfirmationOption.Value.fromString((String)value));
            }
            catch (Exception e) {}
        }
    }

    public void writeExternalUtil(Element element, OptionsAndConfirmations optionsAndConfirmations) throws WriteExternalException {
        Element settingElement;
        Map<String, VcsShowOptionsSettingImpl> options = optionsAndConfirmations.getOptions();
        Map<String, VcsShowConfirmationOptionImpl> confirmations = optionsAndConfirmations.getConfirmations();
        for (VcsShowOptionsSettingImpl vcsShowOptionsSettingImpl : options.values()) {
            settingElement = new Element(OPTIONS_SETTING);
            element.addContent(settingElement);
            settingElement.setAttribute(VALUE_ATTTIBUTE, Boolean.toString(vcsShowOptionsSettingImpl.getValue()));
            settingElement.setAttribute(ID_ATTRIBUTE, vcsShowOptionsSettingImpl.getDisplayName());
        }
        for (VcsShowConfirmationOptionImpl vcsShowConfirmationOptionImpl : confirmations.values()) {
            settingElement = new Element(CONFIRMATIONS_SETTING);
            element.addContent(settingElement);
            settingElement.setAttribute(VALUE_ATTTIBUTE, vcsShowConfirmationOptionImpl.getValue().toString());
            settingElement.setAttribute(ID_ATTRIBUTE, vcsShowConfirmationOptionImpl.getDisplayName());
        }
    }

    public VcsShowConfirmationOption.Value getInitOptionValue(String id) {
        return this.myReadValue.get(id);
    }
}

