/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.impl.FileStatusManagerImpl;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class VcsFileStatusProvider
implements FileStatusProvider {
    private final Project myProject;
    private final FileStatusManagerImpl myFileStatusManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final ChangeListManager myChangeListManager;
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private boolean myHaveEmptyContentRevisions;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.VcsFileStatusProvider");

    public VcsFileStatusProvider(Project project, FileStatusManagerImpl fileStatusManager, ProjectLevelVcsManager vcsManager, ChangeListManager changeListManager, VcsDirtyScopeManager dirtyScopeManager) {
        this.myProject = project;
        this.myFileStatusManager = fileStatusManager;
        this.myVcsManager = vcsManager;
        this.myChangeListManager = changeListManager;
        this.myDirtyScopeManager = dirtyScopeManager;
        this.myHaveEmptyContentRevisions = true;
        this.myFileStatusManager.setFileStatusProvider(this);
        changeListManager.addChangeListListener((ChangeListListener)new ChangeListAdapter(){

            public void changeListAdded(ChangeList list) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListRemoved(ChangeList list) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListChanged(ChangeList list) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListUpdateDone() {
                if (VcsFileStatusProvider.this.myHaveEmptyContentRevisions) {
                    VcsFileStatusProvider.this.myHaveEmptyContentRevisions = false;
                    VcsFileStatusProvider.this.fileStatusesChanged();
                }
            }

            public void unchangedFileStatusChanged() {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }
        });
    }

    private void fileStatusesChanged() {
        this.myFileStatusManager.fileStatusesChanged();
    }

    @Override
    public FileStatus getFileStatus(VirtualFile virtualFile) {
        AbstractVcs vcs = this.myVcsManager.getVcsFor(virtualFile);
        if (vcs == null) {
            return FileStatus.NOT_CHANGED;
        }
        FileStatus status = this.myChangeListManager.getStatus(virtualFile);
        if (status == FileStatus.NOT_CHANGED && VcsFileStatusProvider.isDocumentModified(virtualFile)) {
            return FileStatus.MODIFIED;
        }
        return status;
    }

    private static boolean isDocumentModified(VirtualFile virtualFile) {
        if (virtualFile.isDirectory()) {
            return false;
        }
        FileDocumentManager fdm = FileDocumentManager.getInstance();
        Document editorDocument = fdm.getCachedDocument(virtualFile);
        if (editorDocument != null && editorDocument.getModificationStamp() != virtualFile.getModificationStamp()) {
            return fdm.isDocumentUnsaved(editorDocument);
        }
        return false;
    }

    @Override
    public void refreshFileStatusFromDocument(VirtualFile file, Document doc) {
        FileStatus cachedStatus;
        if (LOG.isDebugEnabled()) {
            LOG.debug("refreshFileStatusFromDocument: file.getModificationStamp()=" + file.getModificationStamp() + ", document.getModificationStamp()=" + doc.getModificationStamp());
        }
        if ((cachedStatus = this.myFileStatusManager.getCachedStatus(file)) == FileStatus.NOT_CHANGED || file.getModificationStamp() == doc.getModificationStamp()) {
            RollbackEnvironment rollbackEnvironment;
            AbstractVcs vcs = this.myVcsManager.getVcsFor(file);
            if (vcs == null) {
                return;
            }
            if (cachedStatus == FileStatus.MODIFIED && file.getModificationStamp() == doc.getModificationStamp() && !((ReadonlyStatusHandlerImpl)ReadonlyStatusHandlerImpl.getInstance((Project)this.myProject)).getState().SHOW_DIALOG && (rollbackEnvironment = vcs.getRollbackEnvironment()) != null) {
                rollbackEnvironment.rollbackIfUnchanged(file);
            }
            this.myFileStatusManager.fileStatusChanged(file);
            ChangeProvider cp = vcs.getChangeProvider();
            if (cp != null && cp.isModifiedDocumentTrackingRequired()) {
                this.myDirtyScopeManager.fileDirty(file);
            }
        }
    }

    @Nullable
    String getBaseVersionContent(final VirtualFile file) {
        Change change = ChangeListManager.getInstance((Project)this.myProject).getChange(file);
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (beforeRevision instanceof BinaryContentRevision) {
                return null;
            }
            if (beforeRevision != null) {
                String content;
                try {
                    content = beforeRevision.getContent();
                }
                catch (VcsException ex) {
                    content = null;
                }
                if (content == null) {
                    this.myHaveEmptyContentRevisions = true;
                }
                return content;
            }
            return null;
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document != null && document.getModificationStamp() != file.getModificationStamp()) {
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return ((Object)LoadTextUtil.loadText(file)).toString();
                }
            });
        }
        return null;
    }
}

