/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericNotifierImpl<T, Key> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.GenericNotifier");
    private final Project myProject;
    @NotNull
    private final String myGroupId;
    @NotNull
    private final String myTitle;
    @NotNull
    private final NotificationType myType;
    @NotNull
    private final Map<Key, MyNotification<T>> myState;
    private final MyListener myListener;
    private final Object myLock;

    protected GenericNotifierImpl(Project project, @NotNull String groupId, @NotNull String title, @NotNull NotificationType type) {
        if (groupId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/impl/GenericNotifierImpl.<init> must not be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vcs/impl/GenericNotifierImpl.<init> must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vcs/impl/GenericNotifierImpl.<init> must not be null");
        }
        this.myGroupId = groupId;
        this.myTitle = title;
        this.myType = type;
        this.myProject = project;
        this.myState = new HashMap<Key, MyNotification<T>>();
        this.myListener = new MyListener();
        this.myLock = new Object();
    }

    protected abstract boolean ask(T var1);

    @NotNull
    protected abstract Key getKey(T var1);

    @NotNull
    protected abstract String getNotificationContent(T var1);

    @NotNull
    protected abstract String getToString(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Key> getAllCurrentKeys() {
        Object object = this.myLock;
        synchronized (object) {
            return new ArrayList<Key>(this.myState.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getStateFor(Key key) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<MyNotification<T>> notifications;
        Object object = this.myLock;
        synchronized (object) {
            notifications = new ArrayList<MyNotification<T>>(this.myState.values());
            this.myState.clear();
        }
        for (MyNotification myNotification : notifications) {
            myNotification.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureNotify(T obj) {
        MyNotification<T> notification;
        Object object = this.myLock;
        synchronized (object) {
            Key key = this.getKey(obj);
            if (this.myState.containsKey(key)) {
                return;
            }
            notification = new MyNotification<T>(this.myGroupId, this.myTitle, this.getNotificationContent(obj), this.myType, this.myListener, obj, this.getToString(obj));
            this.myState.put(key, notification);
        }
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            Notifications.Bus.notify(notification, (NotificationDisplayType)NotificationDisplayType.STICKY_BALLOON, (Project)this.myProject);
        } else {
            application.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Notifications.Bus.notify((Notification)notification, (NotificationDisplayType)NotificationDisplayType.STICKY_BALLOON, (Project)GenericNotifierImpl.this.myProject);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLazyNotificationByKey(Key key) {
        MyNotification<T> notification;
        Object object = this.myLock;
        synchronized (object) {
            notification = this.myState.get(key);
            if (notification != null) {
                this.myState.remove(key);
            }
        }
        if (notification != null) {
            notification.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLazyNotification(T obj) {
        MyNotification<T> notification;
        Object object = this.myLock;
        synchronized (object) {
            Key key = this.getKey(obj);
            notification = this.myState.get(key);
            if (notification != null) {
                this.myState.remove(key);
            }
        }
        if (notification != null) {
            notification.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected T getObj(Key key) {
        Object object = this.myLock;
        synchronized (object) {
            MyNotification<T> notification = this.myState.get(key);
            return notification == null ? null : (T)notification.getObj();
        }
    }

    private static void log(String s) {
        LOG.debug(s);
    }

    protected static class MyNotification<T>
    extends Notification {
        private T myObj;
        private final String myStringPresentation;

        protected MyNotification(@NotNull String groupId, @NotNull String title, @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener, @NotNull T obj, String stringPresentation) {
            if (groupId == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyNotification.<init> must not be null");
            }
            if (title == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyNotification.<init> must not be null");
            }
            if (content == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyNotification.<init> must not be null");
            }
            if (type == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyNotification.<init> must not be null");
            }
            if (obj == null) {
                throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyNotification.<init> must not be null");
            }
            super(groupId, title, content, type, listener);
            this.myObj = obj;
            this.myStringPresentation = stringPresentation;
        }

        public T getObj() {
            return this.myObj;
        }

        public String toString() {
            return this.myStringPresentation;
        }
    }

    private class MyListener
    implements NotificationListener {
        private MyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            MyNotification concreteNotification;
            Object obj;
            boolean state;
            if (notification == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyListener.hyperlinkUpdate must not be null");
            }
            if (event == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyListener.hyperlinkUpdate must not be null");
            }
            if (notification instanceof MyNotification && (state = GenericNotifierImpl.this.ask(obj = (concreteNotification = (MyNotification)notification).getObj()))) {
                Object object = GenericNotifierImpl.this.myLock;
                synchronized (object) {
                    Object key = GenericNotifierImpl.this.getKey(obj);
                    GenericNotifierImpl.this.myState.remove(key);
                }
                notification.expire();
            }
        }
    }
}

