/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.Icon;
import org.apache.oro.io.GlobFilenameFilter;

public class ProjectCheckoutListener
implements CheckoutListener {
    public boolean processCheckedOutDirectory(Project project, File directory) {
        File[] files = directory.listFiles((FilenameFilter)new GlobFilenameFilter("*.ipr"));
        if (files != null && files.length > 0) {
            int rc = Messages.showYesNoDialog((Project)project, (String)VcsBundle.message((String)"checkout.open.project.prompt", (Object[])new Object[]{files[0].getAbsolutePath()}), (String)VcsBundle.message((String)"checkout.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (rc == 0) {
                ProjectUtil.openProject(files[0].getAbsolutePath(), project, false);
            }
            return true;
        }
        return false;
    }
}

