/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChangesBrowserLockedFoldersNode
extends ChangesBrowserNode
implements TreeLinkMouseListener.HaveTooltip {
    private final Project myProject;

    public ChangesBrowserLockedFoldersNode(Project project, Object userObject) {
        super(userObject);
        this.myProject = project;
    }

    @Override
    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        return false;
    }

    @Override
    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
    }

    @Override
    public String getTooltip() {
        return VcsBundle.message((String)"changes.nodetitle.locked.folders.tooltip", (Object[])new Object[0]);
    }

    @Override
    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        renderer.append(this.userObject.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer.append(this.getCountText(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        renderer.append("   ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        CleanupStarter starter = new CleanupStarter(this.myProject, this);
        renderer.append("do cleanup...", new SimpleTextAttributes(16, Color.red), starter);
    }

    private static class CleanupStarter
    implements Runnable {
        private final Project myProject;
        private final ChangesBrowserLockedFoldersNode myParentNode;

        private CleanupStarter(Project project, ChangesBrowserLockedFoldersNode parentNode) {
            this.myProject = project;
            this.myParentNode = parentNode;
        }

        @Override
        public void run() {
            AbstractVcs vcs;
            List<VirtualFile> files = this.myParentNode.getAllFilesUnder();
            ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
            HashMap<String, ArrayList<VirtualFile>> byVcs = new HashMap<String, ArrayList<VirtualFile>>();
            for (VirtualFile virtualFile : files) {
                vcs = plVcsManager.getVcsFor(virtualFile);
                if (vcs == null) continue;
                ArrayList<VirtualFile> list = (ArrayList<VirtualFile>)byVcs.get(vcs.getName());
                if (list == null) {
                    list = new ArrayList<VirtualFile>();
                    byVcs.put(vcs.getName(), list);
                }
                list.add(virtualFile);
            }
            for (Map.Entry entry : byVcs.entrySet()) {
                ChangeProvider changeProvider;
                vcs = plVcsManager.findVcsByName((String)entry.getKey());
                if (vcs == null || (changeProvider = vcs.getChangeProvider()) == null) continue;
                changeProvider.doCleanup((List)entry.getValue());
            }
        }
    }
}

