/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Icons;
import java.io.File;

public class ChangesBrowserFilePathNode
extends ChangesBrowserNode<FilePath> {
    public ChangesBrowserFilePathNode(FilePath userObject) {
        super(userObject);
        if (!userObject.isDirectory()) {
            this.myCount = 1;
        }
    }

    @Override
    protected boolean isDirectory() {
        return ((FilePath)this.getUserObject()).isDirectory() && this.isLeaf();
    }

    @Override
    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        FilePath path = (FilePath)this.userObject;
        if (path.isDirectory() || !this.isLeaf()) {
            renderer.append(ChangesBrowserFilePathNode.getRelativePath(ChangesBrowserFilePathNode.safeCastToFilePath(((ChangesBrowserNode)this.getParent()).getUserObject()), path), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (!this.isLeaf()) {
                this.appendCount(renderer);
            }
            renderer.setIcon(expanded ? Icons.DIRECTORY_OPEN_ICON : Icons.DIRECTORY_CLOSED_ICON);
        } else {
            if (renderer.isShowFlatten()) {
                renderer.append(path.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                FilePath parentPath = path.getParentPath();
                renderer.append(" (" + parentPath.getPresentableUrl() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else {
                renderer.append(ChangesBrowserFilePathNode.getRelativePath(ChangesBrowserFilePathNode.safeCastToFilePath(((ChangesBrowserNode)this.getParent()).getUserObject()), path), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            renderer.setIcon(path.getFileType().getIcon());
        }
    }

    @Override
    public String getTextPresentation() {
        return ((FilePath)this.getUserObject()).getName();
    }

    @Override
    public String toString() {
        return FileUtil.toSystemDependentName((String)((FilePath)this.getUserObject()).getPath());
    }

    public static FilePath safeCastToFilePath(Object o) {
        if (o instanceof FilePath) {
            return (FilePath)o;
        }
        return null;
    }

    public static String getRelativePath(FilePath parent, FilePath child) {
        if (parent == null) {
            return child.getPath().replace('/', File.separatorChar);
        }
        String parentPath = parent.getPath();
        int beginOffset = parentPath.length() == 1 && '/' == parentPath.charAt(0) ? 0 : 1;
        return child.getPath().substring(parent.getPath().length() + beginOffset).replace('/', File.separatorChar);
    }

    @Override
    public int getSortWeight() {
        if (((FilePath)this.userObject).isDirectory()) {
            return 4;
        }
        return 5;
    }

    @Override
    public int compareUserObjects(Object o2) {
        if (o2 instanceof FilePath) {
            return ((FilePath)this.getUserObject()).getPath().compareToIgnoreCase(((FilePath)o2).getPath());
        }
        return 0;
    }

    @Override
    public FilePath[] getFilePathsUnder() {
        return new FilePath[]{(FilePath)this.getUserObject()};
    }
}

