/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Icons;

public class ChangesBrowserFileNode
extends ChangesBrowserNode<VirtualFile> {
    private final Project myProject;

    public ChangesBrowserFileNode(Project project, VirtualFile userObject) {
        super(userObject);
        this.myProject = project;
        if (!userObject.isDirectory()) {
            this.myCount = 1;
        } else {
            this.myDirectoryCount = 1;
        }
    }

    @Override
    protected boolean isDirectory() {
        return ((VirtualFile)this.getUserObject()).isDirectory() && FileStatusManager.getInstance((Project)this.myProject).getStatus((VirtualFile)this.getUserObject()) != FileStatus.NOT_CHANGED;
    }

    @Override
    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        VirtualFile file = (VirtualFile)this.getUserObject();
        renderer.appendFileName(file, file.getName(), ChangeListManager.getInstance((Project)this.myProject).getStatus(file).getColor());
        if (renderer.isShowFlatten() && file.isValid()) {
            VirtualFile parentFile = file.getParent();
            assert (parentFile != null);
            renderer.append(" (" + parentFile.getPresentableUrl() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (this.getCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount(renderer);
        }
        if (file.isDirectory()) {
            renderer.setIcon(Icons.DIRECTORY_CLOSED_ICON);
        } else {
            renderer.setIcon(file.getFileType().getIcon());
        }
    }

    @Override
    public String getTextPresentation() {
        return ((VirtualFile)this.getUserObject()).getName();
    }

    @Override
    public String toString() {
        return ((VirtualFile)this.getUserObject()).getPresentableUrl();
    }

    @Override
    public int getSortWeight() {
        return 7;
    }

    @Override
    public int compareUserObjects(Object o2) {
        if (o2 instanceof VirtualFile) {
            return ((VirtualFile)this.getUserObject()).getName().compareToIgnoreCase(((VirtualFile)o2).getName());
        }
        return 0;
    }
}

