/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.RepositoryChangesBrowser;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeListImpl;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.SeparatorFactory;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;

public class ChangeListViewerDialog
extends DialogWrapper
implements DataProvider {
    private Project myProject;
    private CommittedChangeList myChangeList;
    private RepositoryChangesBrowser myChangesBrowser;
    private JEditorPane myCommitMessageArea;
    private final boolean myInAir;
    private Change[] myChanges;
    private NotNullFunction<Change, Change> myConvertor;
    private JScrollPane commitMessageScroll;

    public ChangeListViewerDialog(Project project, CommittedChangeList changeList) {
        super(project, true);
        this.myInAir = false;
        this.initCommitMessageArea(project, changeList);
        this.initDialog(project, changeList);
    }

    public ChangeListViewerDialog(Component parent, Project project, Collection<Change> changes, boolean inAir) {
        super(parent, true);
        this.myInAir = inAir;
        this.initDialog(project, (CommittedChangeList)new CommittedChangeListImpl("", "", "", -1L, new Date(0L), changes));
    }

    public ChangeListViewerDialog(Project project, Collection<Change> changes, boolean inAir) {
        super(project, true);
        this.myInAir = inAir;
        this.initDialog(project, (CommittedChangeList)new CommittedChangeListImpl("", "", "", -1L, new Date(0L), changes));
    }

    private void initDialog(Project project, CommittedChangeList changeList) {
        this.myProject = project;
        this.myChangeList = changeList;
        Collection changes = this.myChangeList.getChanges();
        this.myChanges = changes.toArray(new Change[changes.size()]);
        this.setTitle(VcsBundle.message((String)"dialog.title.changes.browser", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
        this.setModal(false);
        this.init();
    }

    private void initCommitMessageArea(Project project, CommittedChangeList changeList) {
        this.myCommitMessageArea = new JEditorPane("text/html", "");
        this.myCommitMessageArea.setEditable(false);
        String text = IssueLinkHtmlRenderer.formatTextIntoHtml(project, changeList.getComment().trim());
        this.myCommitMessageArea.setBackground(UIUtil.getComboBoxDisabledBackground());
        this.myCommitMessageArea.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
        this.commitMessageScroll = new JScrollPane(this.myCommitMessageArea);
        this.myCommitMessageArea.setText(text);
        this.myCommitMessageArea.setCaretPosition(0);
    }

    protected String getDimensionServiceKey() {
        return "VCS.ChangeListViewerDialog";
    }

    public Object getData(@NonNls String dataId) {
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return this.myChanges;
        }
        return null;
    }

    public void setConvertor(NotNullFunction<Change, Change> convertor) {
        this.myConvertor = convertor;
    }

    public JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        Splitter splitter = new Splitter(true, 0.9f);
        this.myChangesBrowser = new RepositoryChangesBrowser(this.myProject, Collections.singletonList(this.myChangeList), new ArrayList(this.myChangeList.getChanges()), (ChangeList)this.myChangeList){

            @Override
            protected void showDiffForChanges(Change[] changesArray, int indexInSelection) {
                if (ChangeListViewerDialog.this.myInAir && ChangeListViewerDialog.this.myConvertor != null) {
                    Change[] convertedChanges = new Change[changesArray.length];
                    for (int i = 0; i < changesArray.length; ++i) {
                        Change change = changesArray[i];
                        convertedChanges[i] = (Change)ChangeListViewerDialog.this.myConvertor.fun((Object)change);
                    }
                    super.showDiffForChanges(convertedChanges, indexInSelection);
                } else {
                    super.showDiffForChanges(changesArray, indexInSelection);
                }
            }
        };
        this.myChangesBrowser.setUseCase(this.myInAir ? CommittedChangesBrowserUseCase.IN_AIR : null);
        splitter.setFirstComponent((JComponent)this.myChangesBrowser);
        if (this.myCommitMessageArea != null) {
            JPanel commitPanel = new JPanel(new BorderLayout());
            JComponent separator = SeparatorFactory.createSeparator((String)VcsBundle.message((String)"label.commit.comment", (Object[])new Object[0]), (JComponent)this.myCommitMessageArea);
            commitPanel.add((Component)separator, "North");
            commitPanel.add((Component)this.commitMessageScroll, "Center");
            splitter.setSecondComponent((JComponent)commitPanel);
            splitter.setShowDividerControls(true);
        }
        mainPanel.add((Component)splitter, "Center");
        return mainPanel;
    }

    protected void dispose() {
        this.myChangesBrowser.dispose();
        super.dispose();
    }

    protected Action[] createActions() {
        return new Action[]{this.getCancelAction()};
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myChangesBrowser;
    }
}

