/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.committed.CacheSettingsDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.util.Consumer;

public class RefreshIncomingChangesAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project != null) {
            RefreshIncomingChangesAction.doRefresh(project);
        }
    }

    public static void doRefresh(final Project project) {
        final CommittedChangesCache cache = CommittedChangesCache.getInstance(project);
        cache.hasCachesForAnyRoot(new Consumer<Boolean>(){

            public void consume(Boolean notEmpty) {
                if (!notEmpty.booleanValue() && !CacheSettingsDialog.showSettingsDialog(project)) {
                    return;
                }
                cache.refreshAllCachesAsync(true, false);
                cache.refreshIncomingChangesAsync();
            }
        });
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null && !CommittedChangesCache.getInstance(project).isRefreshingIncomingChanges());
    }
}

