/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListDecorator;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class CommittedChangeListRenderer
extends ColoredTreeCellRenderer {
    private static final DateFormat myDateFormat = DateFormat.getDateTimeInstance(3, 3);
    private static final SimpleTextAttributes LINK_ATTRIBUTES = new SimpleTextAttributes(16, Color.blue);
    private final IssueLinkRenderer myRenderer;
    private final List<CommittedChangeListDecorator> myDecorators;
    private final Project myProject;

    public CommittedChangeListRenderer(Project project, List<CommittedChangeListDecorator> decorators) {
        this.myProject = project;
        this.myRenderer = new IssueLinkRenderer(project, (SimpleColoredComponent)this);
        this.myDecorators = decorators;
    }

    public static String getDateOfChangeList(Date date) {
        return myDateFormat.format(date);
    }

    public static Pair<String, Boolean> getDescriptionOfChangeList(String text) {
        String description = text;
        int pos = description.indexOf("\n");
        if (pos >= 0) {
            description = description.substring(0, pos).trim();
            return new Pair((Object)description, (Object)Boolean.TRUE);
        }
        return new Pair((Object)description, (Object)Boolean.FALSE);
    }

    public static String truncateDescription(String initDescription, FontMetrics fontMetrics, int maxWidth) {
        String description = initDescription;
        int descWidth = fontMetrics.stringWidth(description);
        while (description.length() > 0 && descWidth > maxWidth) {
            description = CommittedChangeListRenderer.trimLastWord(description);
            descWidth = fontMetrics.stringWidth(description + " ");
        }
        return description;
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.customize(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    public void customize(JComponent tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.getUserObject() instanceof CommittedChangeList) {
            CommittedChangeList changeList = (CommittedChangeList)node.getUserObject();
            this.renderChangeList(tree, changeList);
        } else if (node.getUserObject() != null) {
            this.append(node.getUserObject().toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    public void renderChangeList(JComponent tree, CommittedChangeList changeList) {
        CachingCommittedChangesProvider provider;
        boolean partial;
        Container parent = tree.getParent();
        int parentWidth = parent == null ? 100 : parent.getWidth() - 44;
        String date = ", " + CommittedChangeListRenderer.getDateOfChangeList(changeList.getCommitDate());
        FontMetrics fontMetrics = tree.getFontMetrics(tree.getFont());
        FontMetrics boldMetrics = tree.getFontMetrics(tree.getFont().deriveFont(1));
        int size = fontMetrics.stringWidth(date);
        size += boldMetrics.stringWidth(changeList.getCommitterName());
        Pair<String, Boolean> descriptionInfo = CommittedChangeListRenderer.getDescriptionOfChangeList(changeList.getName().trim());
        boolean truncated = (Boolean)descriptionInfo.getSecond();
        String description = (String)descriptionInfo.getFirst();
        for (CommittedChangeListDecorator decorator : this.myDecorators) {
            Icon icon = decorator.decorate(changeList);
            if (icon == null) continue;
            this.setIcon(icon);
        }
        int descMaxWidth = parentWidth - size - 8;
        boolean bl = partial = changeList instanceof ReceivedChangeList && ((ReceivedChangeList)changeList).isPartial();
        if (partial) {
            String partialMarker = VcsBundle.message((String)"committed.changes.partial.list", (Object[])new Object[0]) + " ";
            this.append(partialMarker, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            descMaxWidth -= boldMetrics.stringWidth(partialMarker);
        }
        int descWidth = fontMetrics.stringWidth(description);
        int numberWidth = 0;
        AbstractVcs vcs = changeList.getVcs();
        if (vcs != null && (provider = vcs.getCachingCommittedChangesProvider()) != null && provider.getChangelistTitle() != null) {
            String number = "#" + changeList.getNumber() + "  ";
            numberWidth = fontMetrics.stringWidth(number);
            descWidth += numberWidth;
            this.append(number, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (description.length() == 0 && !truncated) {
            this.append(VcsBundle.message((String)"committed.changes.empty.comment", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            this.appendAlign(parentWidth - size);
        } else if (descMaxWidth < 0) {
            this.myRenderer.appendTextWithLinks(description);
        } else if (descWidth < descMaxWidth && !truncated) {
            this.myRenderer.appendTextWithLinks(description);
            this.appendAlign(parentWidth - size);
        } else {
            String moreMarker = VcsBundle.message((String)"changes.browser.details.marker", (Object[])new Object[0]);
            int moreWidth = fontMetrics.stringWidth(moreMarker);
            description = CommittedChangeListRenderer.truncateDescription(description, fontMetrics, descMaxWidth - moreWidth - numberWidth);
            this.myRenderer.appendTextWithLinks(description);
            this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.append(moreMarker, LINK_ATTRIBUTES, new CommittedChangesTreeBrowser.MoreLauncher(this.myProject, changeList));
            this.appendAlign(parentWidth - size);
        }
        this.append(changeList.getCommitterName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        this.append(date, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    private void appendDescriptionAndNumber(String description, String number) {
        this.myRenderer.appendTextWithLinks(description);
        if (number != null) {
            this.append(number, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    private static String trimLastWord(String description) {
        int pos = description.trim().lastIndexOf(32);
        if (pos >= 0) {
            return description.substring(0, pos).trim();
        }
        return description.substring(0, description.length() - 1);
    }

    public Dimension getPreferredSize() {
        return new Dimension(2000, super.getPreferredSize().height);
    }
}

