/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColumnFilteringStrategy
implements ChangeListFilteringStrategy {
    private final JScrollPane myScrollPane;
    private final JList myValueList;
    private final CopyOnWriteArrayList<ChangeListener> myListeners = ContainerUtil.createEmptyCOWList();
    private final ChangeListColumn myColumn;
    private final Class<? extends CommittedChangesProvider> myProviderClass;
    private final MyListModel myModel;
    private final CommittedChangeListToStringConvertor ourConvertorInstance = new CommittedChangeListToStringConvertor();
    private Object[] myPrefferedSelection;

    public ColumnFilteringStrategy(ChangeListColumn column, Class<? extends CommittedChangesProvider> providerClass) {
        this.myModel = new MyListModel();
        this.myValueList = new JList();
        this.myScrollPane = new JScrollPane(this.myValueList);
        this.myScrollPane.setPreferredSize(new Dimension(100, 100));
        this.myValueList.setModel(this.myModel);
        this.myValueList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                for (ChangeListener listener : ColumnFilteringStrategy.this.myListeners) {
                    listener.stateChanged(new ChangeEvent(this));
                }
            }
        });
        this.myValueList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (index == 0) {
                    this.append(value.toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else if (value.toString().length() == 0) {
                    this.append(VcsBundle.message((String)"committed.changes.filter.none", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else {
                    this.append(value.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        });
        this.myColumn = column;
        this.myProviderClass = providerClass;
    }

    public String toString() {
        return this.myColumn.getTitle();
    }

    @Nullable
    public JComponent getFilterUI() {
        return this.myScrollPane;
    }

    public void setFilterBase(List<CommittedChangeList> changeLists) {
        this.myPrefferedSelection = null;
        this.appendFilterBase(changeLists);
    }

    public void addChangeListener(ChangeListener listener) {
        this.myListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.myListeners.remove(listener);
    }

    public void resetFilterBase() {
        this.myPrefferedSelection = this.myValueList.getSelectedValues();
        this.myValueList.clearSelection();
        this.myModel.clear();
        this.myValueList.revalidate();
        this.myValueList.repaint();
    }

    public void appendFilterBase(List<CommittedChangeList> changeLists) {
        Object[] oldSelection = this.myModel.isEmpty() ? this.myPrefferedSelection : this.myValueList.getSelectedValues();
        this.myModel.addNext(changeLists, this.ourConvertorInstance);
        if (oldSelection != null) {
            for (Object o : oldSelection) {
                this.myValueList.setSelectedValue(o, false);
            }
        }
        this.myValueList.revalidate();
        this.myValueList.repaint();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<CommittedChangeList> filterChangeLists(List<CommittedChangeList> changeLists) {
        List<CommittedChangeList> list;
        Object[] selection = this.myValueList.getSelectedValues();
        if (this.myValueList.getSelectedIndex() == 0 || selection.length == 0) {
            list = changeLists;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/committed/ColumnFilteringStrategy.filterChangeLists must not return null");
            return list;
        }
        ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
        Iterator<CommittedChangeList> i$ = changeLists.iterator();
        block0: while (true) {
            CommittedChangeList changeList;
            if (i$.hasNext()) {
                changeList = i$.next();
                if (this.myProviderClass != null && !this.myProviderClass.isInstance(changeList.getVcs().getCommittedChangesProvider())) continue;
            } else {
                list = result;
                if (list != null) return list;
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/committed/ColumnFilteringStrategy.filterChangeLists must not return null");
            }
            Object[] arr$ = selection;
            int len$ = arr$.length;
            int i$2 = 0;
            while (true) {
                if (i$2 >= len$) continue block0;
                Object value = arr$[i$2];
                if (value.toString().equals(this.myColumn.getValue((ChangeList)ReceivedChangeList.unwrap(changeList)).toString())) {
                    result.add(changeList);
                    continue block0;
                }
                ++i$2;
            }
            break;
        }
    }

    private static class MyListModel
    extends AbstractListModel {
        private volatile String[] myValues = ArrayUtil.EMPTY_STRING_ARRAY;

        private MyListModel() {
        }

        public <T> void addNext(Collection<T> values, Convertor<T, String> convertor) {
            TreeSet<String> set = new TreeSet<String>(Arrays.asList(this.myValues));
            for (T value : values) {
                String converted = (String)convertor.convert(value);
                if (converted == null) continue;
                set.add(converted);
            }
            this.myValues = ArrayUtil.toStringArray(set);
        }

        @Override
        public int getSize() {
            return this.myValues.length + 1;
        }

        public boolean isEmpty() {
            return this.myValues.length == 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index == 0) {
                return VcsBundle.message((String)"committed.changes.filter.all", (Object[])new Object[0]);
            }
            return this.myValues[index - 1];
        }

        public void clear() {
            this.myValues = ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    private class CommittedChangeListToStringConvertor
    implements Convertor<CommittedChangeList, String> {
        private CommittedChangeListToStringConvertor() {
        }

        public String convert(CommittedChangeList o) {
            if (ColumnFilteringStrategy.this.myProviderClass == null || ColumnFilteringStrategy.this.myProviderClass.isInstance(o.getVcs().getCommittedChangesProvider())) {
                return ColumnFilteringStrategy.this.myColumn.getValue((ChangeList)ReceivedChangeList.unwrap(o)).toString();
            }
            return null;
        }
    }
}

