/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFilesComponent;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import java.io.File;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

class ChangeListManagerSerialization {
    @NonNls
    static final String ATT_ID = "id";
    @NonNls
    static final String ATT_NAME = "name";
    @NonNls
    static final String ATT_COMMENT = "comment";
    @NonNls
    static final String ATT_DEFAULT = "default";
    @NonNls
    static final String ATT_READONLY = "readonly";
    @NonNls
    static final String ATT_VALUE_TRUE = "true";
    @NonNls
    static final String ATT_CHANGE_TYPE = "type";
    @NonNls
    static final String ATT_CHANGE_BEFORE_PATH = "beforePath";
    @NonNls
    static final String ATT_CHANGE_AFTER_PATH = "afterPath";
    @NonNls
    static final String ATT_PATH = "path";
    @NonNls
    static final String ATT_MASK = "mask";
    @NonNls
    static final String NODE_LIST = "list";
    @NonNls
    static final String NODE_IGNORED = "ignored";
    @NonNls
    static final String NODE_CHANGE = "change";
    private final IgnoredFilesComponent myIgnoredIdeaLevel;
    private final ChangeListWorker myWorker;

    ChangeListManagerSerialization(IgnoredFilesComponent ignoredIdeaLevel, ChangeListWorker worker) {
        this.myIgnoredIdeaLevel = ignoredIdeaLevel;
        this.myWorker = worker;
    }

    public void readExternal(Element element) throws InvalidDataException {
        List listNodes = element.getChildren(NODE_LIST);
        for (Element listNode : listNodes) {
            this.readChangeList(listNode);
        }
        List ignoredNodes = element.getChildren(NODE_IGNORED);
        for (Element ignoredNode : ignoredNodes) {
            this.readFileToIgnore(ignoredNode);
        }
    }

    private void readChangeList(Element listNode) {
        String changeListName = listNode.getAttributeValue(ATT_NAME);
        LocalChangeList list = this.myWorker.getCopyByName(changeListName);
        if (list == null) {
            list = this.myWorker.addChangeList(listNode.getAttributeValue(ATT_ID), changeListName, listNode.getAttributeValue(ATT_COMMENT), false);
        }
        List changeNodes = listNode.getChildren(NODE_CHANGE);
        for (Element changeNode : changeNodes) {
            try {
                this.myWorker.addChangeToList(changeListName, ChangeListManagerSerialization.readChange(changeNode), null);
            }
            catch (OutdatedFakeRevisionException e) {}
        }
        if (ATT_VALUE_TRUE.equals(listNode.getAttributeValue(ATT_DEFAULT))) {
            this.myWorker.setDefault(list.getName());
        }
        if (ATT_VALUE_TRUE.equals(listNode.getAttributeValue(ATT_READONLY))) {
            list.setReadOnly(true);
        }
    }

    private void readFileToIgnore(Element ignoredNode) {
        String mask;
        IgnoredFileBean bean;
        String path = ignoredNode.getAttributeValue(ATT_PATH);
        if (path != null) {
            Project project = this.myWorker.getProject();
            bean = path.endsWith("/") || path.endsWith(File.separator) ? IgnoredBeanFactory.ignoreUnderDirectory((String)path, (Project)project) : IgnoredBeanFactory.ignoreFile((String)path, (Project)project);
            this.myIgnoredIdeaLevel.add(bean);
        }
        if ((mask = ignoredNode.getAttributeValue(ATT_MASK)) != null) {
            bean = IgnoredBeanFactory.withMask((String)mask);
            this.myIgnoredIdeaLevel.add(bean);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        IgnoredFileBean[] filesToIgnore;
        List<LocalChangeList> changeListList = this.myWorker.getListsCopy();
        for (LocalChangeList list : changeListList) {
            Element listNode = new Element(NODE_LIST);
            element.addContent(listNode);
            if (list.isDefault()) {
                listNode.setAttribute(ATT_DEFAULT, ATT_VALUE_TRUE);
            }
            if (list.isReadOnly()) {
                listNode.setAttribute(ATT_READONLY, ATT_VALUE_TRUE);
            }
            listNode.setAttribute(ATT_ID, list.getId());
            listNode.setAttribute(ATT_NAME, list.getName());
            listNode.setAttribute(ATT_COMMENT, list.getComment());
            for (Change change : list.getChanges()) {
                ChangeListManagerSerialization.writeChange(listNode, change);
            }
        }
        for (IgnoredFileBean bean : filesToIgnore = this.myIgnoredIdeaLevel.getFilesToIgnore()) {
            String mask;
            Element fileNode = new Element(NODE_IGNORED);
            element.addContent(fileNode);
            String path = bean.getPath();
            if (path != null) {
                fileNode.setAttribute(ATT_PATH, path);
            }
            if ((mask = bean.getMask()) == null) continue;
            fileNode.setAttribute(ATT_MASK, mask);
        }
    }

    private static void writeChange(Element listNode, Change change) {
        Element changeNode = new Element(NODE_CHANGE);
        listNode.addContent(changeNode);
        changeNode.setAttribute(ATT_CHANGE_TYPE, change.getType().name());
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision aRev = change.getAfterRevision();
        changeNode.setAttribute(ATT_CHANGE_BEFORE_PATH, bRev != null ? bRev.getFile().getPath() : "");
        changeNode.setAttribute(ATT_CHANGE_AFTER_PATH, aRev != null ? aRev.getFile().getPath() : "");
    }

    private static Change readChange(Element changeNode) throws OutdatedFakeRevisionException {
        String bRev = changeNode.getAttributeValue(ATT_CHANGE_BEFORE_PATH);
        String aRev = changeNode.getAttributeValue(ATT_CHANGE_AFTER_PATH);
        return new Change((ContentRevision)(StringUtil.isEmpty((String)bRev) ? null : new FakeRevision(bRev)), (ContentRevision)(StringUtil.isEmpty((String)aRev) ? null : new FakeRevision(aRev)));
    }

    static final class OutdatedFakeRevisionException
    extends Exception {
        OutdatedFakeRevisionException() {
        }
    }
}

