/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.CompareWithSelectedRevisionAction;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class HighlightAnnotationsActions {
    private final HightlightAction myBefore;
    private final HightlightAction myAfter;
    private final RemoveHighlightingAction myRemove;
    private final EditorGutterComponentEx myGutter;

    public HighlightAnnotationsActions(Project project, VirtualFile virtualFile, FileAnnotation fileAnnotation, EditorGutterComponentEx gutter) {
        this.myGutter = gutter;
        this.myBefore = new HightlightAction(true, project, virtualFile, fileAnnotation, this.myGutter, null);
        List fileRevisionList = fileAnnotation.getRevisions();
        VcsFileRevision afterSelected = fileRevisionList != null && fileRevisionList.size() > 1 ? (VcsFileRevision)fileRevisionList.get(0) : null;
        this.myAfter = new HightlightAction(false, project, virtualFile, fileAnnotation, this.myGutter, afterSelected);
        this.myRemove = new RemoveHighlightingAction();
    }

    public List<AnAction> getList() {
        return Arrays.asList(new AnAction[]{this.myBefore, this.myAfter, this.myRemove});
    }

    public boolean isLineBold(int lineNumber) {
        if (this.turnedOn()) {
            if (this.myBefore.isTurnedOn() && !this.myBefore.isBold(lineNumber)) {
                return false;
            }
            return !this.myAfter.isTurnedOn() || this.myAfter.isBold(lineNumber);
        }
        return false;
    }

    private boolean turnedOn() {
        return this.myBefore.isTurnedOn() || this.myAfter.isTurnedOn();
    }

    private static class HightlightAction
    extends AnAction {
        private final Project myProject;
        private final VirtualFile myVirtualFile;
        private final FileAnnotation myFileAnnotation;
        private final EditorGutterComponentEx myGutter;
        private final boolean myBefore;
        private VcsFileRevision mySelectedRevision;
        private Boolean myShowComments;

        private HightlightAction(boolean before, Project project, VirtualFile virtualFile, FileAnnotation fileAnnotation, EditorGutterComponentEx gutter, @Nullable VcsFileRevision selectedRevision) {
            this.myBefore = before;
            this.myProject = project;
            this.myVirtualFile = virtualFile;
            this.myFileAnnotation = fileAnnotation;
            this.myGutter = gutter;
            this.myShowComments = null;
            this.mySelectedRevision = selectedRevision;
        }

        public void update(AnActionEvent e) {
            String description;
            String text;
            super.update(e);
            if (this.myBefore) {
                text = this.mySelectedRevision == null ? VcsBundle.message((String)"highlight.annotation.before.not.selected.text", (Object[])new Object[0]) : VcsBundle.message((String)"highlight.annotation.before.selected.text", (Object[])new Object[]{this.mySelectedRevision.getRevisionNumber().asString()});
                description = VcsBundle.message((String)"highlight.annotation.before.description", (Object[])new Object[0]);
            } else {
                text = this.mySelectedRevision == null ? VcsBundle.message((String)"highlight.annotation.after.not.selected.text", (Object[])new Object[0]) : VcsBundle.message((String)"highlight.annotation.after.selected.text", (Object[])new Object[]{this.mySelectedRevision.getRevisionNumber().asString()});
                description = VcsBundle.message((String)"highlight.annotation.after.description", (Object[])new Object[0]);
            }
            e.getPresentation().setText(text);
            e.getPresentation().setDescription(description);
            e.getPresentation().setEnabled(this.myFileAnnotation.revisionsNotEmpty());
        }

        public void actionPerformed(AnActionEvent e) {
            List fileRevisionList = this.myFileAnnotation.getRevisions();
            if (fileRevisionList != null) {
                if (this.myShowComments == null) {
                    this.initShowComments(fileRevisionList);
                }
                CompareWithSelectedRevisionAction.showListPopup(fileRevisionList, this.myProject, new Consumer<VcsFileRevision>(){

                    public void consume(VcsFileRevision vcsFileRevision) {
                        HightlightAction.this.mySelectedRevision = vcsFileRevision;
                        HightlightAction.this.myGutter.revalidateMarkup();
                    }
                }, this.myShowComments);
            }
        }

        private void initShowComments(List<VcsFileRevision> revisions) {
            for (VcsFileRevision revision : revisions) {
                if (revision.getCommitMessage() == null) continue;
                this.myShowComments = true;
                return;
            }
            this.myShowComments = false;
        }

        public boolean isTurnedOn() {
            return this.mySelectedRevision != null;
        }

        public void clear() {
            this.mySelectedRevision = null;
        }

        public boolean isBold(int line) {
            VcsRevisionNumber number;
            if (this.mySelectedRevision != null && (number = this.myFileAnnotation.originalRevision(line)) != null) {
                int compareResult = number.compareTo((Object)this.mySelectedRevision.getRevisionNumber());
                return this.myBefore && compareResult <= 0 || !this.myBefore && compareResult >= 0;
            }
            return false;
        }
    }

    private class RemoveHighlightingAction
    extends AnAction {
        private RemoveHighlightingAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("Remove highlighting");
            e.getPresentation().setEnabled(HighlightAnnotationsActions.this.turnedOn());
        }

        public void actionPerformed(AnActionEvent e) {
            HighlightAnnotationsActions.this.myBefore.clear();
            HighlightAnnotationsActions.this.myAfter.clear();
            HighlightAnnotationsActions.this.myGutter.revalidateMarkup();
        }
    }
}

