/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class UpdateChannel {
    private final String myId;
    private final String myName;
    private final ChannelStatus myStatus;
    private final String myHomePageUrl;
    private final String myFeedbackUrl;
    private final List<BuildInfo> myBuilds;

    public UpdateChannel(Element node) {
        this.myId = node.getAttributeValue("id");
        this.myName = node.getAttributeValue("name");
        this.myStatus = ChannelStatus.fromCode(node.getAttributeValue("status"));
        this.myHomePageUrl = node.getAttributeValue("url");
        this.myFeedbackUrl = node.getAttributeValue("feedback");
        this.myBuilds = new ArrayList<BuildInfo>();
        for (Object child : node.getChildren("build")) {
            this.myBuilds.add(new BuildInfo((Element)child));
        }
    }

    @Nullable
    public BuildInfo getLatestBuild() {
        BuildInfo build = null;
        for (BuildInfo info : this.myBuilds) {
            if (build != null && build.compareTo(info) >= 0) continue;
            build = info;
        }
        return build;
    }

    public String getId() {
        return this.myId;
    }

    public String getHomePageUrl() {
        return this.myHomePageUrl;
    }

    public String getFeedbackUrl() {
        return this.myFeedbackUrl;
    }
}

