/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.OrderPanel;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DetectedPluginsPanel
extends OrderPanel<PluginDownloader> {
    private final ArrayList<Listener> myListeners = new ArrayList();
    private static final String AVAILABLE_VERSION = "available version: ";
    private static final String INSTALLED_VERSION = "installed version: ";

    protected DetectedPluginsPanel() {
        super(PluginDownloader.class);
        this.getEntryTable().setDefaultRenderer(PluginDownloader.class, (TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                PluginDownloader downloader = (PluginDownloader)value;
                this.append(downloader.getPluginName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin((PluginId)PluginId.getId((String)downloader.getPluginId()));
                String loadedVersion = downloader.getPluginVersion();
                if (loadedVersion != null || ideaPluginDescriptor != null && ideaPluginDescriptor.getVersion() != null) {
                    this.append(" (" + (ideaPluginDescriptor != null && ideaPluginDescriptor.getVersion() != null ? DetectedPluginsPanel.INSTALLED_VERSION + ideaPluginDescriptor.getVersion() + (loadedVersion != null ? ", " : "") : "") + (loadedVersion != null ? DetectedPluginsPanel.AVAILABLE_VERSION + loadedVersion : "") + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        });
        this.setCheckboxColumnName("");
    }

    public String getCheckboxColumnName() {
        return "";
    }

    public boolean isCheckable(PluginDownloader downloader) {
        return true;
    }

    public boolean isChecked(PluginDownloader downloader) {
        return !UpdateChecker.getDisabledToUpdatePlugins().contains(downloader.getPluginId());
    }

    public void setChecked(PluginDownloader downloader, boolean checked) {
        if (checked) {
            UpdateChecker.getDisabledToUpdatePlugins().remove(downloader.getPluginId());
        } else {
            UpdateChecker.getDisabledToUpdatePlugins().add(downloader.getPluginId());
        }
        for (Listener listener : this.myListeners) {
            listener.stateChanged();
        }
    }

    public void addStateListener(Listener l) {
        this.myListeners.add(l);
    }

    public static interface Listener {
        public void stateChanged();
    }
}

