/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.reporter.ConnectionException;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.SystemInfo;
import java.util.List;

public class CheckForUpdateAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(!SystemInfo.isMacSystemMenu);
    }

    public void actionPerformed(AnActionEvent e) {
        CheckForUpdateAction.actionPerformed(true);
    }

    public static void actionPerformed(boolean enableLink) {
        try {
            UpdateChannel newVersion = UpdateChecker.checkForUpdates();
            List<PluginDownloader> updatedPlugins = UpdateChecker.updatePlugins(true);
            if (newVersion != null) {
                UpdateSettings.getInstance().LAST_TIME_CHECKED = System.currentTimeMillis();
                UpdateChecker.showUpdateInfoDialog(enableLink, newVersion, updatedPlugins);
            } else {
                UpdateChecker.showNoUpdatesDialog(enableLink, updatedPlugins);
            }
        }
        catch (ConnectionException e) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.checkforupdates.connection.failed", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.connection.error", (Object[])new Object[0]));
        }
    }
}

