/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.updateSettings.impl.DetectedPluginsPanel;
import com.intellij.openapi.updateSettings.impl.LabelTextReplacingUtil;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public abstract class AbstractUpdateDialog
extends DialogWrapper {
    private final boolean myEnableLink;
    protected final List<PluginDownloader> myUploadedPlugins;

    protected AbstractUpdateDialog(boolean canBeParent, boolean enableLink, List<PluginDownloader> updatePlugins) {
        super(canBeParent);
        this.myEnableLink = enableLink;
        this.myUploadedPlugins = updatePlugins;
    }

    protected void init() {
        this.setButtonsText();
        super.init();
    }

    protected void initPluginsPanel(final JPanel panel, JPanel pluginsPanel, JPanel wholePluginsPanel, JEditorPane updateLinkPane) {
        panel.setMinimumSize(new Dimension(-1, 200));
        wholePluginsPanel.setVisible(this.myUploadedPlugins != null);
        if (this.myUploadedPlugins != null) {
            DetectedPluginsPanel foundPluginsPanel = new DetectedPluginsPanel();
            foundPluginsPanel.addStateListener(new DetectedPluginsPanel.Listener(){

                @Override
                public void stateChanged() {
                    AbstractUpdateDialog.this.setButtonsText();
                }
            });
            for (PluginDownloader uploadedPlugin : this.myUploadedPlugins) {
                foundPluginsPanel.add(uploadedPlugin);
            }
            pluginsPanel.add((Component)((Object)foundPluginsPanel), "North");
        }
        updateLinkPane.setBackground(UIUtil.getPanelBackground());
        updateLinkPane.setText(IdeBundle.message((String)"updates.configure.label", (Object[])new Object[]{UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont())}));
        updateLinkPane.setEditable(false);
        LabelTextReplacingUtil.replaceText(panel);
        if (this.myEnableLink) {
            updateLinkPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        UpdateSettingsConfigurable updatesSettings = UpdateSettingsConfigurable.getInstance();
                        updatesSettings.setCheckNowEnabled(false);
                        ShowSettingsUtil.getInstance().editConfigurable((Component)panel, (Configurable)updatesSettings);
                        updatesSettings.setCheckNowEnabled(true);
                    }
                }
            });
        }
    }

    private void setButtonsText() {
        this.setOKButtonText(this.getOkButtonText());
        this.setCancelButtonText(CommonBundle.getCancelButtonText());
    }

    protected String getOkButtonText() {
        return CommonBundle.getOkButtonText();
    }

    protected void doOKAction() {
        if (this.doDownloadAndPrepare()) {
            ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            if (app.isRestartCapable()) {
                app.restart();
            } else {
                app.exit(true);
            }
        }
        super.doOKAction();
    }

    protected boolean doDownloadAndPrepare() {
        if (this.myUploadedPlugins != null) {
            UpdateChecker.saveDisabledToUpdatePlugins();
            if (UpdateChecker.install(this.myUploadedPlugins)) {
                return true;
            }
        }
        return false;
    }

    public void doCancelAction() {
        UpdateChecker.saveDisabledToUpdatePlugins();
        if (this.myUploadedPlugins != null) {
            UpdateChecker.install(this.myUploadedPlugins);
        }
        super.doCancelAction();
    }
}

