/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibraryProjectStructureElement
extends ProjectStructureElement {
    private final Library myLibrary;

    public LibraryProjectStructureElement(@NotNull StructureConfigurableContext context, @NotNull Library library) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement.<init> must not be null");
        }
        if (library == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement.<init> must not be null");
        }
        super(context);
        this.myLibrary = library;
    }

    public Library getLibrary() {
        return this.myLibrary;
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
        LibraryEx library = (LibraryEx)this.myContext.getLibraryModel(this.myLibrary);
        if (library == null) {
            return;
        }
        String libraryName = library.getName();
        if (!library.allPathsValid(OrderRootType.CLASSES)) {
            problemsHolder.registerError(ProjectBundle.message((String)"project.roots.tooltip.library.misconfigured", (Object[])new Object[]{libraryName}));
        } else if (!library.allPathsValid(JavadocOrderRootType.getInstance()) || !library.allPathsValid(OrderRootType.SOURCES)) {
            problemsHolder.registerWarning(ProjectBundle.message((String)"project.roots.tooltip.library.misconfigured", (Object[])new Object[]{libraryName}));
        }
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryProjectStructureElement)) {
            return false;
        }
        return this.getSourceOrThis().equals(((LibraryProjectStructureElement)o).getSourceOrThis());
    }

    @NotNull
    private Library getSourceOrThis() {
        InvocationHandler invocationHandler = Proxy.isProxyClass(this.myLibrary.getClass()) ? Proxy.getInvocationHandler(this.myLibrary) : null;
        Library realLibrary = invocationHandler instanceof ModuleEditor.ProxyDelegateAccessor ? (Library)((ModuleEditor.ProxyDelegateAccessor)((Object)invocationHandler)).getDelegate() : this.myLibrary;
        Library source = realLibrary instanceof LibraryImpl ? ((LibraryImpl)realLibrary).getSource() : null;
        Library library = source != null ? source : this.myLibrary;
        if (library == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement.getSourceOrThis must not return null");
        }
        return library;
    }

    @Override
    public int hashCode() {
        return this.getSourceOrThis().hashCode();
    }

    public String toString() {
        return "library:" + this.myLibrary.getName();
    }

    @Override
    public boolean highlightIfUnused() {
        LibraryTable libraryTable = this.myLibrary.getTable();
        return libraryTable != null && "project".equals(libraryTable.getTableLevel());
    }
}

