/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.projectWizard.JdkChooserPanel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import org.jetbrains.annotations.Nullable;

public class IdeaProjectSettingsService
extends ProjectSettingsService {
    private final Project myProject;

    public IdeaProjectSettingsService(Project project) {
        this.myProject = project;
    }

    @Override
    public void openProjectSettings() {
        final ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, new Runnable(){

            @Override
            public void run() {
                config.selectProjectGeneralSettings(true);
            }
        });
    }

    @Override
    public void openModuleSettings(Module module) {
        ModulesConfigurator.showDialog(this.myProject, module.getName(), null, false);
    }

    @Override
    public void openModuleLibrarySettings(Module module) {
        ModulesConfigurator.showDialog(this.myProject, module.getName(), ClasspathEditor.NAME, false);
    }

    @Override
    public void openContentEntriesSettings(Module module) {
        ModulesConfigurator.showDialog(this.myProject, module.getName(), ContentEntriesEditor.NAME, false);
    }

    @Override
    public void openProjectLibrarySettings(final NamedLibraryElement element) {
        final ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, new Runnable(){

            @Override
            public void run() {
                OrderEntry orderEntry = element.getOrderEntry();
                if (orderEntry instanceof JdkOrderEntry) {
                    config.select(((JdkOrderEntry)orderEntry).getJdk(), true);
                } else {
                    config.select((LibraryOrderEntry)orderEntry, true);
                }
            }
        });
    }

    @Override
    public boolean processModulesMoved(Module[] modules, @Nullable ModuleGroup targetGroup) {
        ModuleStructureConfigurable rootConfigurable = ModuleStructureConfigurable.getInstance(this.myProject);
        if (rootConfigurable.updateProjectTree(modules, targetGroup)) {
            if (targetGroup != null) {
                rootConfigurable.selectNodeInTree(targetGroup.toString());
            } else {
                rootConfigurable.selectNodeInTree(modules[0].getName());
            }
            return true;
        }
        return false;
    }

    @Override
    public void showModuleConfigurationDialog(String moduleToSelect, String tabNameToSelect, boolean showModuleWizard) {
        ModulesConfigurator.showDialog(this.myProject, moduleToSelect, tabNameToSelect, showModuleWizard);
    }

    @Override
    public Sdk chooseAndSetSdk() {
        return JdkChooserPanel.chooseAndSetJDK(this.myProject);
    }
}

