/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrderEntryUtil {
    private OrderEntryUtil() {
    }

    @Nullable
    public static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModuleRootModel model, @Nullable Library library) {
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/OrderEntryUtil.findLibraryOrderEntry must not be null");
        }
        return OrderEntryUtil.findLibraryOrderEntry(model, library, false, null);
    }

    @Nullable
    public static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModuleRootModel model, @Nullable Library library, boolean searchInDependencies, ModulesProvider modulesProvider) {
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/OrderEntryUtil.findLibraryOrderEntry must not be null");
        }
        if (library == null) {
            return null;
        }
        for (OrderEntry orderEntry : OrderEntryUtil.getOrderEntries(model, searchInDependencies, modulesProvider)) {
            if (!(orderEntry instanceof LibraryOrderEntry) || !library.equals(((LibraryOrderEntry)orderEntry).getLibrary())) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    private static Collection<? extends OrderEntry> getOrderEntries(ModuleRootModel model, boolean includeDependent, @Nullable ModulesProvider modulesProvider) {
        if (includeDependent) {
            return modulesProvider != null ? OrderEntryUtil.getDependentOrderEntries(model, modulesProvider) : OrderEntryUtil.getDependentOrderEntries(model);
        }
        return Arrays.asList(model.getOrderEntries());
    }

    @Nullable
    public static ModuleOrderEntry findModuleOrderEntry(@NotNull ModuleRootModel model, @Nullable Module module) {
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/OrderEntryUtil.findModuleOrderEntry must not be null");
        }
        return OrderEntryUtil.findModuleOrderEntry(model, module, false, null);
    }

    @Nullable
    public static ModuleOrderEntry findModuleOrderEntry(@NotNull ModuleRootModel model, @Nullable Module module, boolean searchInDependencies, ModulesProvider modulesProvider) {
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/OrderEntryUtil.findModuleOrderEntry must not be null");
        }
        if (module == null) {
            return null;
        }
        for (OrderEntry orderEntry : OrderEntryUtil.getOrderEntries(model, searchInDependencies, modulesProvider)) {
            if (!(orderEntry instanceof ModuleOrderEntry) || !module.equals(((ModuleOrderEntry)orderEntry).getModule())) continue;
            return (ModuleOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public static JdkOrderEntry findJdkOrderEntry(@NotNull ModuleRootModel model, @Nullable Sdk sdk) {
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/OrderEntryUtil.findJdkOrderEntry must not be null");
        }
        if (sdk == null) {
            return null;
        }
        for (OrderEntry orderEntry : OrderEntryUtil.getOrderEntries(model, false, null)) {
            if (!(orderEntry instanceof JdkOrderEntry) || !sdk.equals(((JdkOrderEntry)orderEntry).getJdk())) continue;
            return (JdkOrderEntry)orderEntry;
        }
        return null;
    }

    public static Collection<OrderEntry> getDependentOrderEntries(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/OrderEntryUtil.getDependentOrderEntries must not be null");
        }
        return OrderEntryUtil.getDependentOrderEntries(rootModel, new DefaultModulesProvider(rootModel.getModule().getProject()));
    }

    public static Collection<OrderEntry> getDependentOrderEntries(ModuleRootModel rootModel, ModulesProvider modulesProvider) {
        HashSet<Module> processedModules = new HashSet<Module>();
        processedModules.add(rootModel.getModule());
        return OrderEntryUtil.getDependentOrderEntries(rootModel, processedModules, modulesProvider);
    }

    private static Collection<OrderEntry> getDependentOrderEntries(ModuleRootModel rootModel, Set<Module> processedModules, ModulesProvider modulesProvider) {
        return (Collection)rootModel.processOrder((RootPolicy)new CollectDependentOrderEntries(processedModules, modulesProvider), new LinkedHashSet());
    }

    public static boolean equals(OrderEntry orderEntry1, OrderEntry orderEntry2) {
        if (orderEntry1 instanceof JdkOrderEntry && orderEntry2 instanceof JdkOrderEntry) {
            JdkOrderEntry jdkOrderEntry1 = (JdkOrderEntry)orderEntry1;
            JdkOrderEntry jdkOrderEntry2 = (JdkOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getJdk(), (Object)jdkOrderEntry2.getJdk()) && Comparing.strEqual((String)jdkOrderEntry1.getJdkName(), (String)jdkOrderEntry2.getJdkName());
        }
        if (orderEntry1 instanceof LibraryOrderEntry && orderEntry2 instanceof LibraryOrderEntry) {
            LibraryOrderEntry jdkOrderEntry1 = (LibraryOrderEntry)orderEntry1;
            LibraryOrderEntry jdkOrderEntry2 = (LibraryOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getLibrary(), (Object)jdkOrderEntry2.getLibrary());
        }
        if (orderEntry1 instanceof ModuleSourceOrderEntry && orderEntry2 instanceof ModuleSourceOrderEntry) {
            ModuleSourceOrderEntry jdkOrderEntry1 = (ModuleSourceOrderEntry)orderEntry1;
            ModuleSourceOrderEntry jdkOrderEntry2 = (ModuleSourceOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getOwnerModule(), (Object)jdkOrderEntry2.getOwnerModule());
        }
        if (orderEntry1 instanceof ModuleOrderEntry && orderEntry2 instanceof ModuleOrderEntry) {
            ModuleOrderEntry jdkOrderEntry1 = (ModuleOrderEntry)orderEntry1;
            ModuleOrderEntry jdkOrderEntry2 = (ModuleOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getModule(), (Object)jdkOrderEntry2.getModule());
        }
        return false;
    }

    public static boolean equals(Library library1, Library library2) {
        if (library1 == library2) {
            return true;
        }
        if (library1 == null || library2 == null) {
            return false;
        }
        LibraryTable table = library1.getTable();
        if (table != null) {
            if (library2.getTable() != table) {
                return false;
            }
            String name = library1.getName();
            return name != null && name.equals(library2.getName());
        }
        if (library2.getTable() != null) {
            return false;
        }
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            if (Comparing.equal((Object[])library1.getUrls(type), (Object[])library2.getUrls(type))) continue;
            return false;
        }
        return true;
    }

    public static void addLibraryToRoots(LibraryOrderEntry libraryOrderEntry, Module module) {
        Library library = libraryOrderEntry.getLibrary();
        if (library == null) {
            return;
        }
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = manager.getModifiableModel();
        if (libraryOrderEntry.isModuleLevel()) {
            Library jarLibrary = rootModel.getModuleLibraryTable().createLibrary();
            Library.ModifiableModel libraryModel = jarLibrary.getModifiableModel();
            for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
                VirtualFile[] files;
                for (VirtualFile jarFile : files = library.getFiles(orderRootType)) {
                    libraryModel.addRoot(jarFile, orderRootType);
                }
            }
            libraryModel.commit();
        } else {
            rootModel.addLibraryEntry(library);
        }
        rootModel.commit();
    }

    private static class CollectDependentOrderEntries
    extends RootPolicy<Set<OrderEntry>> {
        private final Set<Module> myProcessedModules;
        private final ModulesProvider myModulesProvider;

        public CollectDependentOrderEntries(Set<Module> processedModules, ModulesProvider modulesProvider) {
            this.myProcessedModules = processedModules;
            this.myModulesProvider = modulesProvider;
        }

        public Set<OrderEntry> visitOrderEntry(OrderEntry orderEntry, Set<OrderEntry> orderEntries) {
            orderEntries.add(orderEntry);
            return orderEntries;
        }

        public Set<OrderEntry> visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, Set<OrderEntry> orderEntries) {
            Module module = moduleOrderEntry.getModule();
            if (module != null && this.myProcessedModules.add(module)) {
                orderEntries.add((OrderEntry)moduleOrderEntry);
                ModuleRootModel modifiableModel = this.myModulesProvider.getRootModel(module);
                Collection dependentOrderEntries = OrderEntryUtil.getDependentOrderEntries(modifiableModel, this.myProcessedModules, this.myModulesProvider);
                orderEntries.addAll(dependentOrderEntries);
            }
            return orderEntries;
        }
    }
}

