/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleOrderEntryImpl
extends OrderEntryBaseImpl
implements ModuleOrderEntry,
WritableOrderEntry,
ClonableOrderEntry {
    @NonNls
    public static final String ENTRY_TYPE = "module";
    @NonNls
    public static final String MODULE_NAME_ATTR = "module-name";
    @NonNls
    private static final String EXPORTED_ATTR = "exported";
    private final ModulePointer myModulePointer;
    private boolean myExported;
    @NotNull
    private DependencyScope myScope;

    ModuleOrderEntryImpl(@NotNull Module module, @NotNull RootModelImpl rootModel) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleOrderEntryImpl.<init> must not be null");
        }
        if (rootModel == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleOrderEntryImpl.<init> must not be null");
        }
        super(rootModel);
        this.myExported = false;
        this.myModulePointer = ModulePointerManager.getInstance((Project)module.getProject()).create(module);
        this.myScope = DependencyScope.COMPILE;
    }

    ModuleOrderEntryImpl(@NotNull String moduleName, @NotNull RootModelImpl rootModel) {
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleOrderEntryImpl.<init> must not be null");
        }
        if (rootModel == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleOrderEntryImpl.<init> must not be null");
        }
        super(rootModel);
        this.myExported = false;
        this.myModulePointer = ModulePointerManager.getInstance((Project)rootModel.getProject()).create(moduleName);
        this.myScope = DependencyScope.COMPILE;
    }

    ModuleOrderEntryImpl(Element element, RootModelImpl rootModel) throws InvalidDataException {
        super(rootModel);
        this.myExported = false;
        this.myExported = element.getAttributeValue(EXPORTED_ATTR) != null;
        String moduleName = element.getAttributeValue(MODULE_NAME_ATTR);
        if (moduleName == null) {
            throw new InvalidDataException();
        }
        this.myModulePointer = ModulePointerManager.getInstance((Project)rootModel.getProject()).create(moduleName);
        this.myScope = DependencyScope.readExternal((Element)element);
    }

    private ModuleOrderEntryImpl(ModuleOrderEntryImpl that, RootModelImpl rootModel) {
        super(rootModel);
        this.myExported = false;
        ModulePointer thatModule = that.myModulePointer;
        this.myModulePointer = ModulePointerManager.getInstance((Project)rootModel.getProject()).create(thatModule.getModuleName());
        this.myExported = that.myExported;
        this.myScope = that.myScope;
    }

    @NotNull
    public Module getOwnerModule() {
        Module module = this.getRootModel().getModule();
        if (module == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleOrderEntryImpl.getOwnerModule must not return null");
        }
        return module;
    }

    @NotNull
    public VirtualFile[] getFiles(OrderRootType type) {
        VirtualFile[] virtualFileArray = this.getFiles(type, (Set<Module>)new HashSet());
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleOrderEntryImpl.getFiles must not return null");
        }
        return virtualFileArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    VirtualFile[] getFiles(OrderRootType type, Set<Module> processed) {
        VirtualFile[] virtualFileArray;
        Module myModule = this.myModulePointer.getModule();
        if (myModule != null && !processed.contains(myModule) && !myModule.isDisposed()) {
            processed.add(myModule);
            if (this.myScope == DependencyScope.RUNTIME && type == OrderRootType.PRODUCTION_COMPILATION_CLASSES) {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
                if (VirtualFile.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleOrderEntryImpl.getFiles must not return null");
                return virtualFileArray;
            }
            if (this.myScope == DependencyScope.TEST && type == OrderRootType.PRODUCTION_COMPILATION_CLASSES) {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
                if (VirtualFile.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleOrderEntryImpl.getFiles must not return null");
                return virtualFileArray;
            }
            if (this.myScope == DependencyScope.PROVIDED && type == OrderRootType.CLASSES_AND_OUTPUT) {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
                if (VirtualFile.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleOrderEntryImpl.getFiles must not return null");
                return virtualFileArray;
            } else {
                virtualFileArray = ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)myModule)).getFilesForOtherModules(type, processed);
                if (virtualFileArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleOrderEntryImpl.getFiles must not return null");
                return virtualFileArray;
            }
        }
        virtualFileArray = VirtualFile.EMPTY_ARRAY;
        if (VirtualFile.EMPTY_ARRAY != null) return virtualFileArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleOrderEntryImpl.getFiles must not return null");
    }

    @NotNull
    public String[] getUrls(OrderRootType rootType) {
        List<String> urls = this.getUrls(rootType, null);
        String[] stringArray = ArrayUtil.toStringArray(urls);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleOrderEntryImpl.getUrls must not return null");
        }
        return stringArray;
    }

    public List<String> getUrls(OrderRootType rootType, @Nullable Set<Module> processed) {
        Module myModule = this.myModulePointer.getModule();
        if (!(myModule == null || myModule.isDisposed() || processed != null && processed.contains(myModule))) {
            if (processed == null) {
                processed = new THashSet();
            }
            processed.add((Module)myModule);
            if (this.myScope == DependencyScope.RUNTIME && rootType == OrderRootType.PRODUCTION_COMPILATION_CLASSES) {
                return Collections.emptyList();
            }
            if (this.myScope == DependencyScope.TEST && rootType == OrderRootType.PRODUCTION_COMPILATION_CLASSES) {
                return Collections.emptyList();
            }
            if (this.myScope == DependencyScope.PROVIDED && rootType == OrderRootType.CLASSES_AND_OUTPUT) {
                return Collections.emptyList();
            }
            return ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)myModule)).getUrlsForOtherModules(rootType, (Set<Module>)processed);
        }
        return Collections.emptyList();
    }

    public boolean isValid() {
        return !this.isDisposed() && this.getModule() != null;
    }

    public <R> R accept(RootPolicy<R> policy, R initialValue) {
        return (R)policy.visitModuleOrderEntry((ModuleOrderEntry)this, initialValue);
    }

    public String getPresentableName() {
        return this.getModuleName();
    }

    public boolean isSynthetic() {
        return false;
    }

    @Nullable
    public Module getModule() {
        return this.getRootModel().getConfigurationAccessor().getModule(this.myModulePointer.getModule(), this.myModulePointer.getModuleName());
    }

    @Override
    public void writeExternal(Element rootElement) throws WriteExternalException {
        Element element = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        element.setAttribute(MODULE_NAME_ATTR, this.getModuleName());
        if (this.myExported) {
            element.setAttribute(EXPORTED_ATTR, "");
        }
        this.myScope.writeExternal(element);
        rootElement.addContent(element);
    }

    public String getModuleName() {
        return this.myModulePointer.getModuleName();
    }

    @Override
    public OrderEntry cloneEntry(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        return new ModuleOrderEntryImpl(this, rootModel);
    }

    public boolean isExported() {
        return this.myExported;
    }

    public void setExported(boolean value) {
        this.getRootModel().assertWritable();
        this.myExported = value;
    }

    @NotNull
    public DependencyScope getScope() {
        DependencyScope dependencyScope = this.myScope;
        if (dependencyScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ModuleOrderEntryImpl.getScope must not return null");
        }
        return dependencyScope;
    }

    public void setScope(@NotNull DependencyScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ModuleOrderEntryImpl.setScope must not be null");
        }
        this.getRootModel().assertWritable();
        this.myScope = scope;
    }
}

