/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerModuleExtensionImpl
extends CompilerModuleExtension {
    @NonNls
    private static final String OUTPUT_TAG = "output";
    @NonNls
    private static final String TEST_OUTPUT_TAG = "output-test";
    @NonNls
    private static final String ATTRIBUTE_URL = "url";
    @NonNls
    private static final String INHERIT_COMPILER_OUTPUT = "inherit-compiler-output";
    @NonNls
    private static final String EXCLUDE_OUTPUT_TAG = "exclude-output";
    private String myCompilerOutput;
    private VirtualFilePointer myCompilerOutputPointer;
    private String myCompilerOutputForTests;
    private VirtualFilePointer myCompilerOutputPathForTestsPointer;
    private boolean myInheritedCompilerOutput;
    private boolean myExcludeOutput;
    private final Module myModule;
    private CompilerModuleExtensionImpl mySource;
    private boolean myWritable;
    private boolean myDisposed;

    public CompilerModuleExtensionImpl(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/CompilerModuleExtensionImpl.<init> must not be null");
        }
        this.myInheritedCompilerOutput = true;
        this.myExcludeOutput = true;
        this.myModule = module;
    }

    public CompilerModuleExtensionImpl(CompilerModuleExtensionImpl source, boolean writable) {
        this(source.myModule);
        this.myWritable = writable;
        this.myCompilerOutput = source.myCompilerOutput;
        this.myCompilerOutputPointer = this.duplicatePointer(source.myCompilerOutputPointer);
        this.myCompilerOutputForTests = source.myCompilerOutputForTests;
        this.myCompilerOutputPathForTestsPointer = this.duplicatePointer(source.myCompilerOutputPathForTestsPointer);
        this.myInheritedCompilerOutput = source.myInheritedCompilerOutput;
        this.myExcludeOutput = source.myExcludeOutput;
        this.mySource = source;
    }

    private VirtualFilePointer duplicatePointer(VirtualFilePointer pointer) {
        if (pointer == null) {
            return null;
        }
        VirtualFilePointerListener listener = ((ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)this.myModule.getProject())).getVirtualFilePointerListener();
        VirtualFilePointerManager filePointerManager = VirtualFilePointerManager.getInstance();
        return filePointerManager.duplicate(pointer, (Disposable)this, listener);
    }

    public void readExternal(Element element) throws InvalidDataException {
        assert (!this.myDisposed);
        String value = element.getAttributeValue(INHERIT_COMPILER_OUTPUT);
        this.myInheritedCompilerOutput = value != null && Boolean.parseBoolean(value);
        this.myExcludeOutput = element.getChild(EXCLUDE_OUTPUT_TAG) != null;
        this.myCompilerOutputPointer = this.getOutputPathValue(element, OUTPUT_TAG, !this.myInheritedCompilerOutput);
        this.myCompilerOutput = CompilerModuleExtensionImpl.getOutputPathValue(element, OUTPUT_TAG);
        this.myCompilerOutputPathForTestsPointer = this.getOutputPathValue(element, TEST_OUTPUT_TAG, !this.myInheritedCompilerOutput);
        this.myCompilerOutputForTests = CompilerModuleExtensionImpl.getOutputPathValue(element, TEST_OUTPUT_TAG);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Element pathElement;
        assert (!this.myDisposed);
        if (this.myCompilerOutput != null) {
            pathElement = new Element(OUTPUT_TAG);
            pathElement.setAttribute(ATTRIBUTE_URL, this.myCompilerOutput);
            element.addContent(pathElement);
        }
        if (this.myCompilerOutputForTests != null) {
            pathElement = new Element(TEST_OUTPUT_TAG);
            pathElement.setAttribute(ATTRIBUTE_URL, this.myCompilerOutputForTests);
            element.addContent(pathElement);
        }
        element.setAttribute(INHERIT_COMPILER_OUTPUT, String.valueOf(this.myInheritedCompilerOutput));
        if (this.myExcludeOutput) {
            element.addContent(new Element(EXCLUDE_OUTPUT_TAG));
        }
    }

    @Nullable
    protected VirtualFilePointer getOutputPathValue(Element element, String tag, boolean createPointer) {
        Element outputPathChild = element.getChild(tag);
        VirtualFilePointer vptr = null;
        if (outputPathChild != null && createPointer) {
            String outputPath = outputPathChild.getAttributeValue(ATTRIBUTE_URL);
            vptr = this.createPointer(outputPath);
        }
        return vptr;
    }

    @Nullable
    protected static String getOutputPathValue(Element element, String tag) {
        Element outputPathChild = element.getChild(tag);
        if (outputPathChild != null) {
            return outputPathChild.getAttributeValue(ATTRIBUTE_URL);
        }
        return null;
    }

    @Nullable
    public VirtualFile getCompilerOutputPath() {
        if (this.myInheritedCompilerOutput) {
            VirtualFile projectOutputPath = CompilerProjectExtension.getInstance((Project)this.getProject()).getCompilerOutput();
            if (projectOutputPath == null) {
                return null;
            }
            return projectOutputPath.findFileByRelativePath("production/" + this.getModule().getName());
        }
        return this.myCompilerOutputPointer == null ? null : this.myCompilerOutputPointer.getFile();
    }

    @Nullable
    public VirtualFile getCompilerOutputPathForTests() {
        if (this.myInheritedCompilerOutput) {
            VirtualFile projectOutputPath = CompilerProjectExtension.getInstance((Project)this.getProject()).getCompilerOutput();
            if (projectOutputPath == null) {
                return null;
            }
            return projectOutputPath.findFileByRelativePath("test/" + this.getModule().getName());
        }
        return this.myCompilerOutputPathForTestsPointer == null ? null : this.myCompilerOutputPathForTestsPointer.getFile();
    }

    @Nullable
    public String getCompilerOutputUrl() {
        if (this.myInheritedCompilerOutput) {
            String projectOutputPath = CompilerProjectExtension.getInstance((Project)this.getProject()).getCompilerOutputUrl();
            if (projectOutputPath == null) {
                return null;
            }
            return projectOutputPath + "/" + "production" + "/" + this.getModule().getName();
        }
        return this.myCompilerOutputPointer == null ? null : this.myCompilerOutputPointer.getUrl();
    }

    @Nullable
    public String getCompilerOutputUrlForTests() {
        if (this.myInheritedCompilerOutput) {
            String projectOutputPath = CompilerProjectExtension.getInstance((Project)this.getProject()).getCompilerOutputUrl();
            if (projectOutputPath == null) {
                return null;
            }
            return projectOutputPath + "/" + "test" + "/" + this.getModule().getName();
        }
        return this.myCompilerOutputPathForTestsPointer == null ? null : this.myCompilerOutputPathForTestsPointer.getUrl();
    }

    public void setCompilerOutputPath(VirtualFile file) {
        this.setCompilerOutputPath(file == null ? null : file.getUrl());
    }

    private VirtualFilePointer createPointer(String url) {
        VirtualFilePointerListener listener = ((ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)this.myModule.getProject())).getVirtualFilePointerListener();
        return VirtualFilePointerManager.getInstance().create(url, (Disposable)this, listener);
    }

    public void setCompilerOutputPath(String url) {
        this.assertWritable();
        this.myCompilerOutput = url;
        this.myCompilerOutputPointer = url == null ? null : this.createPointer(url);
    }

    public void setCompilerOutputPathForTests(VirtualFile file) {
        this.setCompilerOutputPathForTests(file == null ? null : file.getUrl());
    }

    public void setCompilerOutputPathForTests(String url) {
        this.assertWritable();
        this.myCompilerOutputForTests = url;
        this.myCompilerOutputPathForTestsPointer = url == null ? null : this.createPointer(url);
    }

    public Module getModule() {
        return this.myModule;
    }

    public Project getProject() {
        return this.myModule.getProject();
    }

    public void inheritCompilerOutputPath(boolean inherit) {
        this.assertWritable();
        this.myInheritedCompilerOutput = inherit;
    }

    private void assertWritable() {
        assert (this.myWritable) : "Writable model can be retrieved from writable ModifiableRootModel";
    }

    public boolean isCompilerOutputPathInherited() {
        return this.myInheritedCompilerOutput;
    }

    public VirtualFilePointer getCompilerOutputPointer() {
        return this.myCompilerOutputPointer;
    }

    public VirtualFilePointer getCompilerOutputForTestsPointer() {
        return this.myCompilerOutputPathForTestsPointer;
    }

    public void setExcludeOutput(boolean exclude) {
        this.assertWritable();
        this.myExcludeOutput = exclude;
    }

    public boolean isExcludeOutput() {
        return this.myExcludeOutput;
    }

    public CompilerModuleExtension getModifiableModel(boolean writable) {
        assert (!this.myDisposed);
        return new CompilerModuleExtensionImpl(this, writable);
    }

    public void commit() {
        if (this.mySource != null) {
            this.mySource.myCompilerOutput = this.myCompilerOutput;
            boolean old = this.mySource.myWritable;
            this.mySource.myWritable = true;
            this.mySource.setCompilerOutputPath(this.myCompilerOutputPointer == null ? null : this.myCompilerOutputPointer.getUrl());
            this.mySource.myCompilerOutputForTests = this.myCompilerOutputForTests;
            this.mySource.setCompilerOutputPathForTests(this.myCompilerOutputPathForTestsPointer == null ? null : this.myCompilerOutputPathForTestsPointer.getUrl());
            this.mySource.myInheritedCompilerOutput = this.myInheritedCompilerOutput;
            this.mySource.myExcludeOutput = this.myExcludeOutput;
            this.mySource.myWritable = old;
        }
    }

    public boolean isChanged() {
        if (this.myInheritedCompilerOutput != this.mySource.myInheritedCompilerOutput) {
            return true;
        }
        if (!this.myInheritedCompilerOutput) {
            if (!CompilerModuleExtensionImpl.vptrEqual(this.myCompilerOutputPointer, this.mySource.myCompilerOutputPointer)) {
                return true;
            }
            if (!CompilerModuleExtensionImpl.vptrEqual(this.myCompilerOutputPathForTestsPointer, this.mySource.myCompilerOutputPathForTestsPointer)) {
                return true;
            }
        }
        return this.myExcludeOutput != this.mySource.myExcludeOutput;
    }

    private static boolean vptrEqual(VirtualFilePointer p1, VirtualFilePointer p2) {
        return Comparing.equal((String)(p1 == null ? null : p1.getUrl()), (String)(p2 == null ? null : p2.getUrl()));
    }

    public void dispose() {
        this.myDisposed = true;
        this.mySource = null;
        this.myCompilerOutput = null;
        this.myCompilerOutputForTests = null;
    }

    @Nullable
    public VirtualFile[] getRootPaths(OrderRootType type) {
        if (OrderRootType.CLASSES_AND_OUTPUT.equals((Object)type) || OrderRootType.COMPILATION_CLASSES.equals((Object)type) || OrderRootType.PRODUCTION_COMPILATION_CLASSES.equals((Object)type)) {
            VirtualFile outputPathForTests;
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
            VirtualFile outputRoot = this.getCompilerOutputPath();
            if (outputRoot != null) {
                result.add(outputRoot);
            }
            if (!OrderRootType.PRODUCTION_COMPILATION_CLASSES.equals((Object)type) && (outputPathForTests = this.getCompilerOutputPathForTests()) != null && !outputPathForTests.equals(outputRoot)) {
                result.add(outputPathForTests);
            }
            return VfsUtil.toVirtualFileArray(result);
        }
        return null;
    }

    public String[] getRootUrls(OrderRootType type) {
        if (OrderRootType.CLASSES_AND_OUTPUT.equals((Object)type) || OrderRootType.COMPILATION_CLASSES.equals((Object)type) || OrderRootType.PRODUCTION_COMPILATION_CLASSES.equals((Object)type)) {
            String outputPathForTests;
            ArrayList<String> result = new ArrayList<String>();
            String outputRoot = this.getCompilerOutputUrl();
            if (outputRoot != null) {
                result.add(outputRoot);
            }
            if (!OrderRootType.PRODUCTION_COMPILATION_CLASSES.equals((Object)type) && (outputPathForTests = this.getCompilerOutputUrlForTests()) != null && !outputPathForTests.equals(outputRoot)) {
                result.add(outputPathForTests);
            }
            return ArrayUtil.toStringArray(result);
        }
        return null;
    }
}

