/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ColoredListCellRenderer;
import javax.swing.JList;

public class SdkListCellRenderer
extends ColoredListCellRenderer {
    private String myNullText = "";
    private boolean myShowHomePath;

    public SdkListCellRenderer() {
    }

    public SdkListCellRenderer(String nullText) {
        this.myNullText = nullText;
    }

    public SdkListCellRenderer(String nullText, boolean showHomePath) {
        this.myNullText = nullText;
        this.myShowHomePath = showHomePath;
    }

    protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        Sdk sdk = (Sdk)value;
        if (sdk != null) {
            this.setIcon(sdk.getSdkType().getIcon());
            this.append(sdk.getName());
            if (this.myShowHomePath) {
                this.append(" (" + FileUtil.toSystemDependentName((String)sdk.getHomePath()) + ")");
            }
        } else {
            this.append(this.myNullText);
        }
    }
}

