/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.projectRoots.impl.CompositeProjectRoot;
import com.intellij.openapi.projectRoots.impl.SimpleProjectRoot;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ProjectRootUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectRootUtil");
    @NonNls
    public static final String SIMPLE_ROOT = "simple";
    @NonNls
    public static final String COMPOSITE_ROOT = "composite";
    @NonNls
    public static final String JDK_ROOT = "jdk";
    @NonNls
    public static final String OUTPUT_ROOT = "output";
    @NonNls
    public static final String EXCLUDED_OUTPUT = "excludedOutput";
    @NonNls
    public static final String LIBRARY_ROOT = "library";
    @NonNls
    public static final String EJB_ROOT = "ejb";
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";
    @NonNls
    private static final String ELEMENT_ROOT = "root";

    private ProjectRootUtil() {
    }

    static ProjectRoot read(Element element) throws InvalidDataException {
        String type = element.getAttributeValue(ATTRIBUTE_TYPE);
        if (type.equals(SIMPLE_ROOT)) {
            SimpleProjectRoot root = new SimpleProjectRoot();
            root.readExternal(element);
            return root;
        }
        if (type.equals(COMPOSITE_ROOT)) {
            CompositeProjectRoot root = new CompositeProjectRoot();
            root.readExternal(element);
            return root;
        }
        throw new IllegalArgumentException("Wrong type: " + type);
    }

    static Element write(ProjectRoot projectRoot) throws WriteExternalException {
        Element element = new Element(ELEMENT_ROOT);
        if (projectRoot instanceof SimpleProjectRoot) {
            element.setAttribute(ATTRIBUTE_TYPE, SIMPLE_ROOT);
            ((JDOMExternalizable)projectRoot).writeExternal(element);
        } else if (projectRoot instanceof CompositeProjectRoot) {
            element.setAttribute(ATTRIBUTE_TYPE, COMPOSITE_ROOT);
            ((CompositeProjectRoot)projectRoot).writeExternal(element);
        } else {
            throw new IllegalArgumentException("Wrong root: " + projectRoot);
        }
        return element;
    }

    public static PsiDirectory[] convertRoots(Project project, VirtualFile[] roots) {
        return ProjectRootUtil.convertRoots(((PsiManagerImpl)PsiManager.getInstance((Project)project)).getFileManager(), roots);
    }

    public static PsiDirectory[] convertRoots(FileManager fileManager, VirtualFile[] roots) {
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile root : roots) {
            PsiDirectory dir;
            if (!root.isValid()) {
                LOG.error("Root " + root + " is not valid!");
            }
            if ((dir = fileManager.findDirectory(root)) == null) continue;
            dirs.add(dir);
        }
        return dirs.toArray(new PsiDirectory[dirs.size()]);
    }

    public static PsiDirectory[] getRootDirectories(Project project, OrderRootType rootType) {
        VirtualFile[] files = ProjectRootManager.getInstance((Project)project).getFilesFromAllModules(rootType);
        return ProjectRootUtil.convertRoots(project, files);
    }

    public static PsiDirectory[] getAllContentRoots(Project project) {
        VirtualFile[] files = ProjectRootManager.getInstance((Project)project).getContentRootsFromAllModules();
        return ProjectRootUtil.convertRoots(project, files);
    }
}

