/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.ProjectRootListener;
import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.projectRoots.ex.ProjectRootContainer;
import com.intellij.openapi.projectRoots.impl.CompositeProjectRoot;
import com.intellij.openapi.projectRoots.impl.ProjectRootUtil;
import com.intellij.openapi.projectRoots.impl.SimpleProjectRoot;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ProjectRootContainerImpl
implements JDOMExternalizable,
ProjectRootContainer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectRootContainerImpl");
    private final Map<OrderRootType, CompositeProjectRoot> myRoots = new HashMap();
    private Map<OrderRootType, VirtualFile[]> myFiles = new HashMap();
    private boolean myInsideChange = false;
    private final List<ProjectRootListener> myListeners = ContainerUtil.createEmptyCOWList();
    private boolean myNoCopyJars = false;

    public ProjectRootContainerImpl(boolean noCopyJars) {
        this.myNoCopyJars = noCopyJars;
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            this.myRoots.put(rootType, new CompositeProjectRoot());
            this.myFiles.put(rootType, VirtualFile.EMPTY_ARRAY);
        }
    }

    @Override
    @NotNull
    public VirtualFile[] getRootFiles(OrderRootType type) {
        VirtualFile[] virtualFileArray = this.myFiles.get(type);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl.getRootFiles must not return null");
        }
        return virtualFileArray;
    }

    @Override
    public ProjectRoot[] getRoots(OrderRootType type) {
        return this.myRoots.get(type).getProjectRoots();
    }

    @Override
    public void startChange() {
        LOG.assertTrue(!this.myInsideChange);
        this.myInsideChange = true;
    }

    @Override
    public void finishChange() {
        LOG.assertTrue(this.myInsideChange);
        HashMap oldRoots = new HashMap(this.myFiles);
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            Object[] roots = this.myRoots.get(orderRootType).getVirtualFiles();
            boolean same = Comparing.equal((Object[])roots, (Object[])((Object[])oldRoots.get((Object)orderRootType)));
            this.myFiles.put(orderRootType, this.myRoots.get(orderRootType).getVirtualFiles());
            if (same) continue;
            this.fireRootsChanged();
        }
        this.myInsideChange = false;
    }

    public void addProjectRootContainerListener(ProjectRootListener listener) {
        this.myListeners.add(listener);
    }

    public void removeProjectRootContainerListener(ProjectRootListener listener) {
        this.myListeners.remove(listener);
    }

    private void fireRootsChanged() {
        for (ProjectRootListener listener : this.myListeners) {
            listener.rootsChanged();
        }
    }

    @Override
    public void removeRoot(ProjectRoot root, OrderRootType type) {
        LOG.assertTrue(this.myInsideChange);
        this.myRoots.get(type).remove(root);
    }

    @Override
    public ProjectRoot addRoot(VirtualFile virtualFile, OrderRootType type) {
        LOG.assertTrue(this.myInsideChange);
        return this.myRoots.get(type).add(virtualFile);
    }

    @Override
    public void addRoot(ProjectRoot root, OrderRootType type) {
        LOG.assertTrue(this.myInsideChange);
        this.myRoots.get(type).add(root);
    }

    @Override
    public void removeAllRoots(OrderRootType type) {
        LOG.assertTrue(this.myInsideChange);
        this.myRoots.get(type).clear();
    }

    @Override
    public void removeRoot(VirtualFile root, OrderRootType type) {
        LOG.assertTrue(this.myInsideChange);
        this.myRoots.get(type).remove(root);
    }

    @Override
    public void removeAllRoots() {
        LOG.assertTrue(this.myInsideChange);
        for (CompositeProjectRoot myRoot : this.myRoots.values()) {
            myRoot.clear();
        }
    }

    @Override
    public void update() {
        LOG.assertTrue(this.myInsideChange);
        for (CompositeProjectRoot myRoot : this.myRoots.values()) {
            myRoot.update();
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        for (PersistentOrderRootType type : OrderRootType.getAllPersistentTypes()) {
            this.read(element, type);
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                ProjectRootContainerImpl.this.myFiles = (Map)new HashMap();
                for (OrderRootType rootType : ProjectRootContainerImpl.this.myRoots.keySet()) {
                    CompositeProjectRoot root = (CompositeProjectRoot)ProjectRootContainerImpl.this.myRoots.get(rootType);
                    if (ProjectRootContainerImpl.this.myNoCopyJars) {
                        ProjectRootContainerImpl.setNoCopyJars(root);
                    }
                    ProjectRootContainerImpl.this.myFiles.put(rootType, root.getVirtualFiles());
                }
            }
        });
        PersistentOrderRootType[] arr$ = OrderRootType.getAllTypes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            PersistentOrderRootType type;
            Object[] oldRoots = VirtualFile.EMPTY_ARRAY;
            type = arr$[i$];
            Object[] newRoots = this.getRootFiles((OrderRootType)type);
            if (Comparing.equal((Object[])oldRoots, (Object[])newRoots)) continue;
            this.fireRootsChanged();
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        List allTypes = OrderRootType.getSortedRootTypes();
        for (PersistentOrderRootType type : allTypes) {
            this.write(element, type);
        }
    }

    private static void setNoCopyJars(ProjectRoot root) {
        if (root instanceof SimpleProjectRoot) {
            String url = ((SimpleProjectRoot)root).getUrl();
            if ("jar".equals(VirtualFileManager.extractProtocol((String)url))) {
                String path = VirtualFileManager.extractPath((String)url);
                JarFileSystem.getInstance().setNoCopyJarForPath(path);
            }
        } else if (root instanceof CompositeProjectRoot) {
            ProjectRoot[] roots;
            for (ProjectRoot root1 : roots = ((CompositeProjectRoot)root).getProjectRoots()) {
                ProjectRootContainerImpl.setNoCopyJars(root1);
            }
        }
    }

    private void read(Element element, PersistentOrderRootType type) throws InvalidDataException {
        Element child = element.getChild(type.getSdkRootName());
        if (child == null) {
            this.myRoots.put((OrderRootType)type, new CompositeProjectRoot());
            return;
        }
        List children = child.getChildren();
        LOG.assertTrue(children.size() == 1);
        this.myRoots.put((OrderRootType)type, (CompositeProjectRoot)ProjectRootUtil.read((Element)children.get(0)));
    }

    private void write(Element roots, PersistentOrderRootType type) throws WriteExternalException {
        Element e = new Element(type.getSdkRootName());
        roots.addContent(e);
        Element root = ProjectRootUtil.write(this.myRoots.get(type));
        if (root != null) {
            e.addContent(root);
        }
    }

    void readOldVersion(Element child) {
        block0: for (Object o : child.getChildren("root")) {
            Element root = (Element)o;
            String url = root.getAttributeValue("file");
            SimpleProjectRoot projectRoot = new SimpleProjectRoot(url);
            String type = root.getChild("property").getAttributeValue("value");
            for (PersistentOrderRootType rootType : OrderRootType.getAllPersistentTypes()) {
                if (!type.equals(rootType.getOldSdkRootName())) continue;
                this.addRoot(projectRoot, (OrderRootType)rootType);
                continue block0;
            }
        }
        this.myFiles = new HashMap();
        for (OrderRootType rootType : this.myRoots.keySet()) {
            this.myFiles.put(rootType, this.myRoots.get(rootType).getVirtualFiles());
        }
        OrderRootType[] arr$ = OrderRootType.getAllTypes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object[] oldRoots = VirtualFile.EMPTY_ARRAY;
            OrderRootType type = arr$[i$];
            Object[] newRoots = this.getRootFiles(type);
            if (Comparing.equal((Object[])oldRoots, (Object[])newRoots)) continue;
            this.fireRootsChanged();
        }
    }
}

