/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class MockJdkWrapper
implements Sdk {
    private final String myHomePath;
    private final Sdk myDelegate;

    public MockJdkWrapper(String homePath, @NotNull Sdk delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/projectRoots/impl/MockJdkWrapper.<init> must not be null");
        }
        this.myHomePath = homePath;
        this.myDelegate = delegate;
    }

    public VirtualFile getHomeDirectory() {
        return LocalFileSystem.getInstance().findFileByIoFile(new File(this.getHomePath()));
    }

    public String getHomePath() {
        String homePath = FileUtil.toSystemDependentName((String)(this.myHomePath == null ? this.myDelegate.getHomePath() : this.myHomePath));
        return StringUtil.trimEnd((String)homePath, (String)File.separator);
    }

    public SdkType getSdkType() {
        return this.myDelegate.getSdkType();
    }

    public String getName() {
        return this.myDelegate.getName();
    }

    public String getVersionString() {
        return this.myDelegate.getVersionString();
    }

    public RootProvider getRootProvider() {
        return this.myDelegate.getRootProvider();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public SdkAdditionalData getSdkAdditionalData() {
        return null;
    }

    public SdkModificator getSdkModificator() {
        return null;
    }
}

