/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressFunComponentProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.SmoothProgressAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.PsiLock;
import com.intellij.ui.SystemNotifications;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressManagerImpl
extends ProgressManager {
    @NonNls
    private static final String PROCESS_CANCELED_EXCEPTION = "idea.ProcessCanceledException";
    private static final ThreadLocal<ProgressIndicator> myThreadIndicator = new ThreadLocal();
    private final AtomicInteger myCurrentProgressCount = new AtomicInteger(0);
    private final AtomicInteger myCurrentUnsafeProgressCount = new AtomicInteger(0);
    private final AtomicInteger myCurrentModalProgressCount = new AtomicInteger(0);
    private static volatile int ourLockedCheckCounter = 0;
    private final List<ProgressFunComponentProvider> myFunComponentProviders = new ArrayList<ProgressFunComponentProvider>();
    @NonNls
    private static final String NAME = "Progress Cancel Checker";
    private static final boolean DISABLED = Comparing.equal((String)System.getProperty("idea.ProcessCanceledException"), (String)"disabled");

    public ProgressManagerImpl(Application application) {
        if (!application.isUnitTestMode() && !DISABLED) {
            Thread thread = new Thread(NAME){

                @Override
                public void run() {
                    while (true) {
                        try {
                            1.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ourNeedToCheckCancel = true;
                    }
                }
            };
            thread.setPriority(9);
            thread.start();
        }
    }

    protected void doCheckCanceled() throws ProcessCanceledException {
        ProgressIndicator progress = this.getProgressIndicator();
        if (progress != null) {
            try {
                progress.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                if (DISABLED) {
                    return;
                }
                if (Thread.holdsLock(PsiLock.LOCK)) {
                    if (++ourLockedCheckCounter > 10) {
                        ourLockedCheckCounter = 0;
                        ourNeedToCheckCancel = true;
                    }
                }
                ourLockedCheckCounter = 0;
                throw e;
            }
        }
    }

    public static void canceled() {
        ourNeedToCheckCancel = true;
    }

    public NonCancelableSection startNonCancelableSection() {
        NonCancelableIndicator nonCancelor = new NonCancelableIndicator(myThreadIndicator.get());
        myThreadIndicator.set((ProgressIndicator)nonCancelor);
        return nonCancelor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeNonCancelableSection(Runnable r) {
        NonCancelableSection nonCancelor = this.startNonCancelableSection();
        try {
            r.run();
        }
        finally {
            nonCancelor.done();
        }
    }

    public JComponent getProvidedFunComponent(Project project, String processId) {
        for (ProgressFunComponentProvider provider : (ProgressFunComponentProvider[])Extensions.getExtensions((ExtensionPointName)ProgressFunComponentProvider.EP_NAME)) {
            JComponent cmp = provider.getProgressFunComponent(project, processId);
            if (cmp == null) continue;
            return cmp;
        }
        for (ProgressFunComponentProvider provider : this.myFunComponentProviders) {
            JComponent cmp = provider.getProgressFunComponent(project, processId);
            if (cmp == null) continue;
            return cmp;
        }
        return null;
    }

    public void setCancelButtonText(String cancelButtonText) {
        ProgressIndicator original;
        ProgressIndicator progressIndicator = this.getProgressIndicator();
        if (progressIndicator != null && progressIndicator instanceof SmoothProgressAdapter && cancelButtonText != null && (original = ((SmoothProgressAdapter)progressIndicator).getOriginal()) instanceof ProgressWindow) {
            ((ProgressWindow)original).setCancelButtonText(cancelButtonText);
        }
    }

    public void registerFunComponentProvider(ProgressFunComponentProvider provider) {
        this.myFunComponentProviders.add(provider);
    }

    public void removeFunComponentProvider(ProgressFunComponentProvider provider) {
        this.myFunComponentProviders.remove(provider);
    }

    public boolean hasProgressIndicator() {
        return this.myCurrentProgressCount.get() > 0;
    }

    public boolean hasUnsafeProgressIndicator() {
        return this.myCurrentUnsafeProgressCount.get() > 0;
    }

    public boolean hasModalProgressIndicator() {
        return this.myCurrentModalProgressCount.get() > 0;
    }

    public void runProcess(final @NotNull Runnable process, final ProgressIndicator progress) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl.runProcess must not be null");
        }
        this.executeProcessUnderProgress(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Runnable runnable = process;
                synchronized (runnable) {
                    process.notify();
                }
                try {
                    if (progress != null && !progress.isRunning()) {
                        progress.start();
                    }
                    process.run();
                }
                finally {
                    if (progress != null && progress.isRunning()) {
                        progress.stop();
                        if (progress instanceof ProgressIndicatorEx) {
                            ((ProgressIndicatorEx)progress).processFinish();
                        }
                    }
                }
            }
        }, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeProcessUnderProgress(@NotNull Runnable process, ProgressIndicator progress) throws ProcessCanceledException {
        boolean modal;
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl.executeProcessUnderProgress must not be null");
        }
        ProgressIndicator oldIndicator = myThreadIndicator.get();
        if (progress != null) {
            myThreadIndicator.set(progress);
        }
        this.myCurrentProgressCount.incrementAndGet();
        boolean bl = modal = progress != null && progress.isModal();
        if (modal) {
            this.myCurrentModalProgressCount.incrementAndGet();
        }
        if (progress == null || progress instanceof ProgressWindow) {
            this.myCurrentUnsafeProgressCount.incrementAndGet();
        }
        try {
            process.run();
        }
        finally {
            myThreadIndicator.set(oldIndicator);
            this.myCurrentProgressCount.decrementAndGet();
            if (modal) {
                this.myCurrentModalProgressCount.decrementAndGet();
            }
            if (progress == null || progress instanceof ProgressWindow) {
                this.myCurrentUnsafeProgressCount.decrementAndGet();
            }
        }
    }

    public ProgressIndicator getProgressIndicator() {
        return myThreadIndicator.get();
    }

    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process, String progressTitle, boolean canBeCanceled, Project project) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl.runProcessWithProgressSynchronously must not be null");
        }
        return this.runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project, null);
    }

    public boolean runProcessWithProgressSynchronously(final @NotNull Runnable process, String progressTitle, boolean canBeCanceled, Project project, JComponent parentComponent) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl.runProcessWithProgressSynchronously must not be null");
        }
        Task.Modal task = new Task.Modal(project, progressTitle, canBeCanceled){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl$3.run must not be null");
                }
                process.run();
            }
        };
        return ProgressManagerImpl.runProcessWithProgressSynchronously((Task)task, parentComponent);
    }

    private static boolean runProcessWithProgressSynchronously(final Task task, JComponent parentComponent) {
        long start = System.currentTimeMillis();
        boolean result = ((ApplicationEx)ApplicationManager.getApplication()).runProcessWithProgressSynchronously(new TaskContainer(task){

            @Override
            public void run() {
                new TaskRunnable(task, ProgressManager.getInstance().getProgressIndicator()).run();
            }
        }, task.getTitle(), task.isCancellable(), task.getProject(), parentComponent, task.getCancelText());
        if (result) {
            JFrame frame;
            long end = System.currentTimeMillis();
            Task.NotificationInfo notificationInfo = task.getNotificationInfo();
            if (notificationInfo != null && end - start > 5000L && !(frame = WindowManager.getInstance().getFrame(task.getProject())).hasFocus()) {
                ProgressManagerImpl.systemNotify(notificationInfo);
            }
            task.onSuccess();
        } else {
            task.onCancel();
        }
        return result;
    }

    private static void systemNotify(Task.NotificationInfo notificationInfo) {
        SystemNotifications notifications = (SystemNotifications)ServiceManager.getService(SystemNotifications.class);
        if (notifications == null) {
            return;
        }
        notifications.notify(notificationInfo.getNotificationName(), notificationInfo.getNotificationTitle(), notificationInfo.getNotificationText());
    }

    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull String progressTitle, @NotNull Runnable process, @Nullable Runnable successRunnable, @Nullable Runnable canceledRunnable) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl.runProcessWithProgressAsynchronously must not be null");
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl.runProcessWithProgressAsynchronously must not be null");
        }
        if (process == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl.runProcessWithProgressAsynchronously must not be null");
        }
        this.runProcessWithProgressAsynchronously(project, progressTitle, process, successRunnable, canceledRunnable, PerformInBackgroundOption.DEAF);
    }

    public void runProcessWithProgressAsynchronously(@NotNull Project project, @Nls @NotNull String progressTitle, final @NotNull Runnable process, final @Nullable Runnable successRunnable, final @Nullable Runnable canceledRunnable, @NotNull PerformInBackgroundOption option) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl.runProcessWithProgressAsynchronously must not be null");
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl.runProcessWithProgressAsynchronously must not be null");
        }
        if (process == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl.runProcessWithProgressAsynchronously must not be null");
        }
        if (option == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl.runProcessWithProgressAsynchronously must not be null");
        }
        ProgressManagerImpl.runProcessWithProgressAsynchronously(new Task.Backgroundable(project, progressTitle, true, option){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl$5.run must not be null");
                }
                process.run();
            }

            public void onCancel() {
                if (canceledRunnable != null) {
                    canceledRunnable.run();
                }
            }

            public void onSuccess() {
                if (successRunnable != null) {
                    successRunnable.run();
                }
            }
        });
    }

    public static void runProcessWithProgressAsynchronously(Task.Backgroundable task) {
        Object progressIndicator = ApplicationManager.getApplication().isHeadlessEnvironment() ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(task);
        ProgressManagerImpl.runProcessWithProgressAsynchronously(task, (ProgressIndicator)progressIndicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runProcessWithProgressAsynchronously(final Task.Backgroundable task, final ProgressIndicator progressIndicator) {
        if (progressIndicator instanceof Disposable) {
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)((Disposable)progressIndicator));
        }
        final TaskRunnable process = new TaskRunnable((Task)task, progressIndicator);
        TaskContainer action = new TaskContainer((Task)task){

            @Override
            public void run() {
                boolean canceled = false;
                long start = System.currentTimeMillis();
                try {
                    ProgressManager.getInstance().runProcess(process, progressIndicator);
                }
                catch (ProcessCanceledException e) {
                    canceled = true;
                }
                long end = System.currentTimeMillis();
                if (canceled || progressIndicator.isCanceled()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            task.onCancel();
                        }
                    }, ModalityState.NON_MODAL);
                } else if (!canceled) {
                    Window window;
                    Task.NotificationInfo notificationInfo = task.getNotificationInfo();
                    if (notificationInfo != null && end - start > 5000L && ((window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null || notificationInfo.isShowWhenFocused())) {
                        ProgressManagerImpl.systemNotify(notificationInfo);
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            task.onSuccess();
                        }
                    }, ModalityState.NON_MODAL);
                }
            }
        };
        TaskRunnable taskRunnable = process;
        synchronized (taskRunnable) {
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)action);
            try {
                process.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void run(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl.run must not be null");
        }
        if (task.isHeadless()) {
            new TaskRunnable(task, (ProgressIndicator)new EmptyProgressIndicator()).run();
            return;
        }
        if (task.isModal()) {
            ProgressManagerImpl.runProcessWithProgressSynchronously((Task)task.asModal(), null);
        } else {
            Task.Backgroundable backgroundable = task.asBackgroundable();
            if (backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground()) {
                ProgressManagerImpl.runProcessWithProgressSynchronously(task, null);
            } else {
                ProgressManagerImpl.runProcessWithProgressAsynchronously(backgroundable);
            }
        }
    }

    private static void stopCheckCanceled() {
        Thread[] threads = new Thread[500];
        Thread.enumerate(threads);
        for (Thread thread : threads) {
            if (thread == null || !NAME.equals(thread.getName())) continue;
            Thread.State oldState = thread.getState();
            thread.suspend();
            System.out.println(thread + " suspended (" + (Object)((Object)oldState) + "->" + (Object)((Object)thread.getState()) + ")");
        }
    }

    public static void setNeedToCheckCancel(boolean needToCheckCancel) {
        ourNeedToCheckCancel = needToCheckCancel;
    }

    private static class TaskRunnable
    extends TaskContainer {
        private final ProgressIndicator myIndicator;

        private TaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator) {
            if (task == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl$TaskRunnable.<init> must not be null");
            }
            if (indicator == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/progress/impl/ProgressManagerImpl$TaskRunnable.<init> must not be null");
            }
            super(task);
            this.myIndicator = indicator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.getTask().run(this.myIndicator);
            }
            finally {
                if (this.myIndicator instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)this.myIndicator).finish((TaskInfo)this.getTask());
                }
            }
        }
    }

    private static abstract class TaskContainer
    implements Runnable {
        private final Task myTask;

        protected TaskContainer(Task task) {
            this.myTask = task;
        }

        public Task getTask() {
            return this.myTask;
        }
    }

    private static class NonCancelableIndicator
    extends EmptyProgressIndicator
    implements NonCancelableSection {
        private final ProgressIndicator myOld;

        private NonCancelableIndicator(ProgressIndicator old) {
            this.myOld = old;
        }

        public void done() {
            ProgressIndicator currentIndicator = (ProgressIndicator)myThreadIndicator.get();
            if (currentIndicator != this) {
                throw new AssertionError((Object)"Trying do .done() NonCancelableSection, which is already done");
            }
            myThreadIndicator.set(this.myOld);
        }

        public void checkCanceled() {
        }
    }
}

