/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.Queue;
import gnu.trove.THashSet;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModuleWithDependentsScope
extends GlobalSearchScope {
    private final Module myModule;
    private final boolean myOnlyTests;
    private final ProjectFileIndex myProjectFileIndex;
    private final Set<Module> myModules;

    public ModuleWithDependentsScope(Module module, boolean onlyTests) {
        super(module.getProject());
        this.myModule = module;
        this.myOnlyTests = onlyTests;
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)this.myModule.getProject()).getFileIndex();
        this.myModules = new HashSet<Module>();
        this.myModules.add(this.myModule);
        this.fillModules();
    }

    private void fillModules() {
        Queue walkingQueue = new Queue(10);
        walkingQueue.addLast((Object)this.myModule);
        Module[] allModules = ModuleManager.getInstance((Project)this.myModule.getProject()).getModules();
        THashSet processed = new THashSet();
        while (!walkingQueue.isEmpty()) {
            Module current = (Module)walkingQueue.pullFirst();
            processed.add(current);
            for (Module dependent : allModules) {
                for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)dependent).getOrderEntries()) {
                    if (!(orderEntry instanceof ModuleOrderEntry) || !current.equals(((ModuleOrderEntry)orderEntry).getModule())) continue;
                    this.myModules.add(dependent);
                    if (processed.contains(dependent) || !((ModuleOrderEntry)orderEntry).isExported()) continue;
                    walkingQueue.addLast((Object)dependent);
                }
            }
        }
    }

    public boolean contains(VirtualFile file) {
        Module moduleOfFile = this.myProjectFileIndex.getModuleForFile(file);
        if (moduleOfFile == null) {
            return false;
        }
        if (!this.myModules.contains(moduleOfFile)) {
            return false;
        }
        if (this.myOnlyTests && !this.myProjectFileIndex.isInTestSourceContent(file)) {
            return false;
        }
        return !this.myProjectFileIndex.isInLibraryClasses(file) || this.myProjectFileIndex.isInSourceContent(file);
    }

    public int compare(VirtualFile file1, VirtualFile file2) {
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope.isSearchInModuleContent must not be null");
        }
        return this.myModules.contains(aModule);
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    @NonNls
    public String toString() {
        return "Module with dependents:" + this.myModule.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleWithDependentsScope)) {
            return false;
        }
        ModuleWithDependentsScope moduleWithDependentsScope = (ModuleWithDependentsScope)((Object)o);
        if (this.myOnlyTests != moduleWithDependentsScope.myOnlyTests) {
            return false;
        }
        return this.myModule.equals(moduleWithDependentsScope.myModule);
    }

    public int hashCode() {
        return this.myModule.hashCode();
    }
}

